% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_to_zipfs.R
\name{data_to_zipfs}
\alias{data_to_zipfs}
\title{Transforms \code{\link[latentFactoR]{simulate_factors}} Data to Zipf's Distribution}
\usage{
data_to_zipfs(lf_object, beta = 2.7, alpha = 1, dichotomous = FALSE)
}
\arguments{
\item{lf_object}{Data object from \code{\link[latentFactoR]{simulate_factors}}}

\item{beta}{Numeric (length = 1).
Sets the shift in rank.
Defaults to \code{2.7}}

\item{alpha}{Numeric (length = 1).
Sets the power of the rank.
Defaults to \code{1}}

\item{dichotomous}{Boolean (length = 1).
Whether data should be dichotomized rather
than frequencies (e.g., semantic network analysis).
Defaults to \code{FALSE}}
}
\value{
Returns a list containing:

\item{data}{Simulated data that has been transform to follow Zipf's distribution}

\item{RMSE}{A vector of root mean square errors for transformed data and data
assumed to follow theoretical Zipf's distribution and Spearman's correlation
matrix of the transformed data compared to the original population correlation
matrix}

\item{spearman_correlation}{Spearman's correlation matrix of the transformed data}

\item{original_correlation}{Original population correlation matrix \emph{before}
the data were transformed}

\item{original_results}{Original \code{lf_object} input into function}
}
\description{
Zipf's distribution is commonly found for text data. Closely related to the
Pareto and power-law distributions, the Zipf's distribution produces
highly skewed data. This transformation is intended to mirror the data
generating process of Zipf's law seen in semantic network and topic
modeling data.
}
\details{
The formula used to transform data is (Piantadosi, 2014):

\emph{f(r) proportional to 1 / (r + beta)^alpha}

where \emph{f(r)} is the \emph{r}th most frequency,
\emph{r} is the rank-order of the data, \emph{beta}
is a shift in the rank (following Mandelbrot, 1953, 1962),
and \emph{alpha} is the power of the rank with greater
values suggesting greater differences between the largest
frequency to the next, and so forth.

The function will transform continuous data output from \code{\link[latentFactoR]{simulate_factors}}. 
See examples to get started
}
\examples{
# Generate factor data
two_factor <- simulate_factors(
  factors = 2, # factors = 2
  variables = 6, # variables per factor = 6
  loadings = 0.55, # loadings between = 0.45 to 0.65
  cross_loadings = 0.05, # cross-loadings N(0, 0.05)
  correlations = 0.30, # correlation between factors = 0.30
  sample_size = 1000 # number of cases = 1000
)

# Transform data to Mandelbrot's Zipf's
two_factor_zipfs <- data_to_zipfs(
  lf_object = two_factor,
  beta = 2.7,
  alpha = 1
)

# Transform data to Mandelbrot's Zipf's (dichotomous)
two_factor_zipfs_binary <- data_to_zipfs(
  lf_object = two_factor,
  beta = 2.7,
  alpha = 1,
  dichotomous = TRUE
)

}
\references{
Mandelbrot, B. (1953).
An informational theory of the statistical structure of language.
\emph{Communication Theory}, \emph{84}, 486–502.

Mandelbrot, B. (1962).
On the theory of word frequencies and on related Markovian models of discourse.
\emph{Structure of Language and its Mathematical Aspects}, 190–219.

Piantadosi, S. T. (2014).
Zipf’s word frequency law in natural language: A critical review and future directions.
\emph{Psychonomic Bulletin & Review}, \emph{21}(5), 1112-1130.

Zipf, G. (1936).
\emph{The psychobiology of language}.
London, UK: Routledge.

Zipf, G. (1949).
\emph{Human behavior and the principle of least effort}. 
New York, NY: Addison-Wesley.
}
\author{
Alexander P. Christensen <alexpaulchristensen@gmail.com>,
Hudson Golino <hfg9s@virginia.edu>,
Luis Eduardo Garrido <luisgarrido@pucmm.edu>
}
