% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsm_l_contig_sd.R
\name{lsm_l_contig_sd}
\alias{lsm_l_contig_sd}
\title{CONTIG_SD (landscape level)}
\usage{
lsm_l_contig_sd(landscape, directions = 8)
}
\arguments{
\item{landscape}{A categorical raster object: SpatRaster; Raster* Layer, Stack, Brick; stars or a list of SpatRasters.}

\item{directions}{The number of directions in which patches should be connected: 4 (rook's case) or 8 (queen's case).}
}
\value{
tibble
}
\description{
Standard deviation of Contiguity index (Shape metric)
}
\details{
\deqn{CONTIG_{SD} =  sd(CONTIG[patch_{ij}])}

where \eqn{CONTIG[patch_{ij}]} is the contiguity of each patch.

CONTIG_SD is a 'Shape metric'. It summarises the landscape as the standard deviation of all patches
in the landscape. CONTIG_SD asses the spatial connectedness (contiguity) of
cells in patches. The metric coerces patch values to a value of 1 and the background
to NA. A nine cell focal filter matrix:

\if{html}{\out{<div class="sourceCode">}}\preformatted{filter_matrix <- matrix(c(1, 2, 1,
                          2, 1, 2,
                          1, 2, 1), 3, 3, byrow = TRUE)
}\if{html}{\out{</div>}}

... is then used to weight orthogonally contiguous pixels more heavily than
diagonally contiguous pixels. Therefore, larger and more connections between
patch cells in the rookie case result in larger contiguity index values.

\subsection{Units}{None}
\subsection{Range}{CONTIG_SD >= 0}
\subsection{Behaviour}{CONTIG_SD = 0 if the contiguity index is
identical for all patches. Increases, without limit, as the variation of
CONTIG increases.}
}
\examples{
landscape <- terra::rast(landscapemetrics::landscape)
lsm_l_contig_sd(landscape)

}
\references{
McGarigal K., SA Cushman, and E Ene. 2023. FRAGSTATS v4: Spatial Pattern Analysis
Program for Categorical Maps. Computer software program produced by the authors;
available at the following web site: https://www.fragstats.org

LaGro, J. 1991. Assessing patch shape in landscape mosaics.
Photogrammetric Engineering and Remote Sensing, 57(3), 285-293
}
\seealso{
\code{\link{lsm_p_contig}},
\code{\link{lsm_c_contig_sd}},
\code{\link{lsm_c_contig_cv}},
\code{\link{lsm_c_contig_mn}}, \cr
\code{\link{lsm_l_contig_cv}},
\code{\link{lsm_l_contig_mn}}
}
