% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_adjacencies.R
\name{get_adjacencies}
\alias{get_adjacencies}
\title{get_adjacencies}
\usage{
get_adjacencies(landscape, neighbourhood = 4, what = "full", upper = FALSE)
}
\arguments{
\item{landscape}{A categorical raster object: SpatRaster; Raster* Layer, Stack, Brick; stars or a list of SpatRasters.}

\item{neighbourhood}{The number of directions in which cell adjacencies are
considered as neighbours: 4 (rook's case), 8 (queen's case) or a binary matrix
where the ones define the neighbourhood. The default is 4.}

\item{what}{Which adjacencies to calculate: "full" for a full adjacency matrix,
"like" for the diagonal, "unlike" for the off diagonal part of the matrix and
"triangle" for a triangular matrix counting adjacencies only once.}

\item{upper}{Logical value indicating whether the upper triangle of the adjacency matrix
should be returned (default FALSE).}
}
\value{
matrix with adjacencies between classes in a raster and between cells from the same class.
}
\description{
Fast calculation of adjacencies between classes in a raster
}
\details{
A fast implementation with Rcpp to calculate the adjacency matrix for raster.
The adjacency matrix is most often used in landscape metrics to describe
the configuration of landscapes, is it is a cellwise count of edges between classes.

The "full" adjacency matrix is double-count method, as it contains the pairwise
counts of cells between all classes. The diagonal of this matrix contains the
like adjacencies, a count for how many edges a shared in each class with the same class.

The "unlike" adjacencies are counting the cellwise edges between different classes.
}
\examples{
landscape <- terra::rast(landscapemetrics::landscape)
# calculate full adjacency matrix
get_adjacencies(landscape, 4)

# equivalent with the terra package:
adjacencies <- terra::adjacent(landscape, 1:terra::ncell(landscape), "rook", pairs = TRUE)
table(terra::values(landscape, mat = FALSE)[adjacencies[,1]],
terra::values(landscape, mat = FALSE)[adjacencies[,2]])

# count diagonal neighbour adjacencies
diagonal_matrix <- matrix(c(1,  NA,  1,
                            NA,  0, NA,
                            1,  NA,  1), 3, 3, byrow = TRUE)
get_adjacencies(landscape, diagonal_matrix)

}
