% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsm_p_gyrate.R
\name{lsm_p_gyrate}
\alias{lsm_p_gyrate}
\title{GYRATE (patch level)}
\usage{
lsm_p_gyrate(landscape, directions = 8, cell_center = FALSE)
}
\arguments{
\item{landscape}{Raster* Layer, Stack, Brick, SpatRaster (terra), stars, or a list of rasterLayers.}

\item{directions}{The number of directions in which patches should be
connected: 4 (rook's case) or 8 (queen's case).}

\item{cell_center}{If true, the coordinates of the centroid are forced to be
a cell center within the patch.}
}
\value{
tibble
}
\description{
Radius of Gyration (Area and edge metric)
}
\details{
\deqn{GYRATE = \sum \limits_{r = 1}^{z} \frac{h_{ijr}} {z}}
where \eqn{h_{ijr}} is the distance from each cell to the centroid of the
patch and \eqn{z} is the number of cells.

GYRATE is an 'Area and edge metric'. The distance from each cell to the
patch centroid is based on cell center to centroid distances. The metric
characterises both the patch area and compactness.

If \code{cell_center = TRUE} some patches might have several possible cell-center
centroids. In this case, the gyrate index is based on the mean distance of all
cells to all possible cell-center centroids.

\subsection{Units}{Meters}
\subsection{Range}{GYRATE >= 0}
\subsection{Behaviour}{Approaches GYRATE = 0 if patch is a single cell.
Increases, without limit, when only one patch is present.}
}
\examples{
lsm_p_gyrate(landscape)

}
\references{
McGarigal, K., SA Cushman, and E Ene. 2012. FRAGSTATS v4: Spatial Pattern Analysis
Program for Categorical and Continuous Maps. Computer software program produced by
the authors at the University of Massachusetts, Amherst. Available at the following
web site: https://www.umass.edu/landeco/

Keitt, T. H., Urban, D. L., & Milne, B. T. 1997. Detecting critical scales
in fragmented landscapes. Conservation ecology, 1(1).
}
\seealso{
\code{\link{lsm_c_gyrate_mn}},
\code{\link{lsm_c_gyrate_sd}},
\code{\link{lsm_c_gyrate_cv}}, \cr
\code{\link{lsm_l_gyrate_mn}},
\code{\link{lsm_l_gyrate_sd}},
\code{\link{lsm_l_gyrate_cv}}
}
