% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsm_c_gyrate_sd.R
\name{lsm_c_gyrate_sd}
\alias{lsm_c_gyrate_sd}
\title{GYRATE_SD (class level)}
\usage{
lsm_c_gyrate_sd(landscape, directions = 8, cell_center = FALSE)
}
\arguments{
\item{landscape}{Raster* Layer, Stack, Brick, SpatRaster (terra), stars, or a list of rasterLayers.}

\item{directions}{The number of directions in which patches should be
connected: 4 (rook's case) or 8 (queen's case).}

\item{cell_center}{If true, the coordinates of the centroid are forced to be
a cell center within the patch.}
}
\value{
tibble
}
\description{
Standard deviation radius of gyration (Area and edge metric)
}
\details{
\deqn{GYRATE_{SD} = sd(GYRATE[patch_{ij}])}
where \eqn{GYRATE[patch_{ij}]} equals the radius of gyration of each patch.

GYRATE_SD is an 'Area and edge metric'. The metric summarises each class
as the standard deviation of the radius of gyration of all patches
belonging to class i. GYRATE measures the distance from each cell to the patch
centroid and is based on cell center-to-cell center distances. The metrics characterises
both the patch area and compactness.

If \code{cell_center = TRUE} some patches might have several possible cell-center
centroids. In this case, the gyrate index is based on the mean distance of all
cells to all possible cell-center centroids.

\subsection{Units}{Meters}
\subsection{Range}{GYRATE_SD >= 0 }
\subsection{Behaviour}{Equals GYRATE_SD = 0 if the radius of gyration is identical
for all patches. Increases, without limit, as the variation of the radius of gyration
increases.}
}
\examples{
lsm_c_gyrate_sd(landscape)

}
\references{
McGarigal, K., SA Cushman, and E Ene. 2012. FRAGSTATS v4: Spatial Pattern Analysis
Program for Categorical and Continuous Maps. Computer software program produced by
the authors at the University of Massachusetts, Amherst. Available at the following
web site: https://www.umass.edu/landeco/

Keitt, T. H., Urban, D. L., & Milne, B. T. 1997. Detecting critical scales
in fragmented landscapes. Conservation ecology, 1(1).
}
\seealso{
\code{\link{lsm_p_gyrate}},
\code{\link{cv}}, \cr
\code{\link{lsm_c_gyrate_mn}},
\code{\link{lsm_c_gyrate_cv}}, \cr
\code{\link{lsm_l_gyrate_mn}},
\code{\link{lsm_l_gyrate_sd}},
\code{\link{lsm_l_gyrate_cv}}
}
