% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kmeRs_score.R
\name{kmeRs_score}
\alias{kmeRs_score}
\title{Sort a k-mer Similarity Matrix}
\usage{
kmeRs_score(x, decreasing = FALSE)
}
\arguments{
\item{x}{the similarity matrix calculated by \code{kmeRs_similarity_matrix} function}

\item{decreasing}{when TRUE, results are sorted decreasing}
}
\value{
sorted similarity matrix with global.score column added; is returned as a data.frame
}
\description{
The \code{kmeRs_score} function sums the partial scores and sort the data.frame
to indicate the most 'different' k-mers
}
\examples{
# Calculate the example BLOSUM62 matrix and score the result

example <- kmeRs_similarity_matrix(kmers_given = c("A", "T", "C", "G"), submat = "BLOSUM62")
kmeRs_score(example)

}
