% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/permshap.R
\name{permshap}
\alias{permshap}
\alias{permshap.default}
\alias{permshap.ranger}
\title{Permutation SHAP}
\usage{
permshap(object, ...)

\method{permshap}{default}(
  object,
  X,
  bg_X = NULL,
  pred_fun = stats::predict,
  feature_names = colnames(X),
  bg_w = NULL,
  bg_n = 200L,
  parallel = FALSE,
  parallel_args = NULL,
  verbose = TRUE,
  ...
)

\method{permshap}{ranger}(
  object,
  X,
  bg_X = NULL,
  pred_fun = NULL,
  feature_names = colnames(X),
  bg_w = NULL,
  bg_n = 200L,
  parallel = FALSE,
  parallel_args = NULL,
  verbose = TRUE,
  survival = c("chf", "prob"),
  ...
)
}
\arguments{
\item{object}{Fitted model object.}

\item{...}{Additional arguments passed to \code{pred_fun(object, X, ...)}.}

\item{X}{\eqn{(n \times p)} matrix or \code{data.frame} with rows to be explained.
The columns should only represent model features, not the response
(but see \code{feature_names} on how to overrule this).}

\item{bg_X}{Background data used to integrate out "switched off" features,
often a subset of the training data (typically 50 to 500 rows).
In cases with a natural "off" value (like MNIST digits),
this can also be a single row with all values set to the off value.
If no \code{bg_X} is passed (the default) and if \code{X} is sufficiently large,
a random sample of \code{bg_n} rows from \code{X} serves as background data.}

\item{pred_fun}{Prediction function of the form \verb{function(object, X, ...)},
providing \eqn{K \ge 1} predictions per row. Its first argument
represents the model \code{object}, its second argument a data structure like \code{X}.
Additional (named) arguments are passed via \code{...}.
The default, \code{\link[stats:predict]{stats::predict()}}, will work in most cases.}

\item{feature_names}{Optional vector of column names in \code{X} used to calculate
SHAP values. By default, this equals \code{colnames(X)}. Not supported if \code{X}
is a matrix.}

\item{bg_w}{Optional vector of case weights for each row of \code{bg_X}.
If \code{bg_X = NULL}, must be of same length as \code{X}. Set to \code{NULL} for no weights.}

\item{bg_n}{If \code{bg_X = NULL}: Size of background data to be sampled from \code{X}.}

\item{parallel}{If \code{TRUE}, use parallel \code{\link[foreach:foreach]{foreach::foreach()}} to loop over rows
to be explained. Must register backend beforehand, e.g., via 'doFuture' package,
see README for an example. Parallelization automatically disables the progress bar.}

\item{parallel_args}{Named list of arguments passed to \code{\link[foreach:foreach]{foreach::foreach()}}.
Ideally, this is \code{NULL} (default). Only relevant if \code{parallel = TRUE}.
Example on Windows: if \code{object} is a GAM fitted with package 'mgcv',
then one might need to set \code{parallel_args = list(.packages = "mgcv")}.}

\item{verbose}{Set to \code{FALSE} to suppress messages and the progress bar.}

\item{survival}{Should cumulative hazards ("chf", default) or survival
probabilities ("prob") per time be predicted? Only in \code{ranger()} survival models.}
}
\value{
An object of class "kernelshap" with the following components:
\itemize{
\item \code{S}: \eqn{(n \times p)} matrix with SHAP values or, if the model output has
dimension \eqn{K > 1}, a list of \eqn{K} such matrices.
\item \code{X}: Same as input argument \code{X}.
\item \code{baseline}: Vector of length K representing the average prediction on the
background data.
\item \code{bg_X}: The background data.
\item \code{bg_w}: The background case weights.
\item \code{m_exact}: Integer providing the effective number of exact on-off vectors used.
\item \code{exact}: Logical flag indicating whether calculations are exact or not
(currently \code{TRUE}).
\item \code{txt}: Summary text.
\item \code{predictions}: \eqn{(n \times K)} matrix with predictions of \code{X}.
\item \code{algorithm}: "permshap".
}
}
\description{
Exact permutation SHAP algorithm with respect to a background dataset,
see Strumbelj and Kononenko. The function works for up to 14 features.
For eight or more features, we recomment to switch to \code{\link[=kernelshap]{kernelshap()}}.
}
\section{Methods (by class)}{
\itemize{
\item \code{permshap(default)}: Default permutation SHAP method.

\item \code{permshap(ranger)}: Permutation SHAP method for "ranger" models, see Readme for an example.

}}
\examples{
# MODEL ONE: Linear regression
fit <- lm(Sepal.Length ~ ., data = iris)

# Select rows to explain (only feature columns)
X_explain <- iris[-1]

# Calculate SHAP values
s <- permshap(fit, X_explain)
s

# MODEL TWO: Multi-response linear regression
fit <- lm(as.matrix(iris[, 1:2]) ~ Petal.Length + Petal.Width + Species, data = iris)
s <- permshap(fit, iris[3:5])
s

# Note 1: Feature columns can also be selected 'feature_names'
# Note 2: Especially when X is small, pass a sufficiently large background data bg_X
s <- permshap(
  fit,
  iris[1:4, ],
  bg_X = iris,
  feature_names = c("Petal.Length", "Petal.Width", "Species")
)
s
}
\references{
\enumerate{
\item Erik Strumbelj and Igor Kononenko. Explaining prediction models and individual
predictions with feature contributions. Knowledge and Information Systems 41, 2014.
}
}
