#' Mental Load Data
#'
#' Three physiological measures during a mental load assessment experiment on aviation pilots
#'
#' @docType data
#'
#' @usage data(MentalLoad)
#' @format Dataframe with 1393 rows and 4 columns. The first column indicates the experimental period,
#' while the last three columns correspond to the three physiological measures monitored during the experiment:
#' Heart rate (HR), respiration rate (RR) and petCO2.
#'
#' @keywords datasets
#'
#' @references Grassmann, M., Vlemincx, E., von Leupoldt, A., & Van den Bergh, O. (2016). The role of respiratory measures to assess mental load in pilot
#'                    selection. \emph{Ergonomics}, 59(6), 745-753. (\href{https://pubmed.ncbi.nlm.nih.gov/26444137}{PubMed})
#'
#' @examples
#' data(MentalLoad)
"MentalLoad"
#> [1] "Mentalload"
