% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{simulate.fitted_dlm}
\alias{simulate.fitted_dlm}
\title{Draw samples from the distribution of the latent states}
\usage{
\method{simulate}{fitted_dlm}(object, nsim, seed = NULL, lag = -1, ...)
}
\arguments{
\item{object}{fitted_dlm: A fitted model from which to sample.}

\item{nsim}{integer: The number of samples to draw.}

\item{seed}{integer: An object specifying if and how the random number generator should be initialized.}

\item{lag}{integer: The relative offset for forecast. Values for time t will be calculated based on the filtered values of time t-h. If lag is negative, then the smoothed distribution for the latent states will be used.}

\item{...}{Extra arguments passed to the plot method.}
}
\value{
A list containing the following values:
\itemize{
   \item theta array: An array containing a sample of the latent states. Dimensions are n x t x nsim, where n is the number of latent states in the model and t is the number of observed values.
   \item lambda array: An array containing a sample of the linear predictors. Dimensions are k x t x nsim, where k is the number of linear predictors in the model and t is the number of observed values.
   \item param list: A named list containing, for each model outcome, an array with the samples of the parameters of the observational model. Each array will have dimensions l x t x nsim, where l is the number of parameters in the observational model and t is the number of observed values.
}
}
\description{
This is function draws samples from the latent states using the backward sampling algorithm. See \insertCite{WestHarr-DLM;textual}{kDGLM}, chapter 15, for details.
}
\examples{

structure <- polynomial_block(mu = 1, D = 0.95) +
  polynomial_block(V = 1, D = 0.95)

outcome <- Normal(mu = "mu", V = "V", data = cornWheat$corn.log.return[1:500])
fitted.data <- fit_model(structure, corn = outcome)

sample <- simulate(fitted.data, 5000)

}
\seealso{
Other auxiliary functions for fitted_dlm objects: 
\code{\link{coef.fitted_dlm}()},
\code{\link{eval_dlm_norm_const}()},
\code{\link{fit_model}()},
\code{\link{forecast.fitted_dlm}()},
\code{\link{smoothing}()},
\code{\link{update.fitted_dlm}()}
}
\concept{auxiliary functions for fitted_dlm objects}
