% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/priors.R
\name{joint_prior}
\alias{joint_prior}
\title{Joint prior}
\usage{
joint_prior(
  block,
  var.index = 1:block$n,
  a1 = block$a1[var.index],
  R1 = block$R1[var.index, var.index]
)
}
\arguments{
\item{block}{dlm_block object: The structural block.}

\item{var.index}{Integer: The index of the variables from which to set the prior.}

\item{a1}{Numeric: The prior mean.}

\item{R1}{Matrix: The prior covariance matrix.}
}
\value{
A dlm_block object with the desired prior.
}
\description{
Defines the joint prior of a structural block.
}
\details{
The discount factor must be the same for all variables whose prior is being modified.
For the details about the implementation see \insertCite{ArtigoPacote;textual}{kDGLM}.
}
\examples{

polynomial_block(mu = 1, D = 0.95) |>
  block_mult(5) |>
  joint_prior(var.index = 1:2, R1 = matrix(c(1, 0.5, 0.5, 1), 2, 2))

}
\references{
\insertAllCited{}
}
\seealso{
Other auxiliary functions for defining priors.: 
\code{\link{CAR_prior}()},
\code{\link{zero_sum_prior}()}
}
\concept{auxiliary functions for defining priors.}
