% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/structure_helper.R
\name{block_mult}
\alias{block_mult}
\title{Auxiliary function to replicate blocks}
\usage{
block_mult(block, k)
}
\arguments{
\item{block}{dlm_block: A block to be replicated}

\item{k}{Integer: The number of blocks to generate.}
}
\value{
The combined replicated blocks as a dlm_block.
}
\description{
An auxiliary function to replicate blocks.
}
\examples{
# Long way
level <- polynomial_block(alpha = 1, order = 1)

final.block <- block_mult(level, 5)

# Short way
final.block <- 5 * polynomial_block(alpha = 1, order = 1)

}
\seealso{
Other auxiliary functions for structural blocks: 
\code{\link{TF_block}()},
\code{\link{block_rename}()},
\code{\link{block_superpos}()},
\code{\link{harmonic_block}()},
\code{\link{intervention}()},
\code{\link{noise_block}()},
\code{\link{polynomial_block}()},
\code{\link{regression_block}()},
\code{\link{specify.dlm_block}()},
\code{\link{summary.dlm_block}()}
}
\concept{auxiliary functions for structural blocks}
