// Generated by rstantools.  Do not edit by hand.

/*
    jfa is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    jfa is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with jfa.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.21.0
#include <stan/model/model_header.hpp>
namespace model_pp_taint_namespace {
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;
static int current_statement_begin__;
stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_pp_taint");
    reader.add_event(0, 0, "include", "/include/license.stan");
    reader.add_event(0, 0, "start", "/include/license.stan");
    reader.add_event(14, 14, "end", "/include/license.stan");
    reader.add_event(14, 1, "restart", "model_pp_taint");
    reader.add_event(77, 62, "end", "model_pp_taint");
    return reader;
}
#include <stan_meta_header.hpp>
class model_pp_taint
  : public stan::model::model_base_crtp<model_pp_taint> {
private:
        int S;
        int n;
        std::vector<int> s;
        std::vector<double> t;
        double alpha;
        double beta;
        int beta_prior;
        int gamma_prior;
        int normal_prior;
        int uniform_prior;
        int cauchy_prior;
        int t_prior;
        int chisq_prior;
        int exponential_prior;
        int use_likelihood;
public:
    model_pp_taint(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, 0, pstream__);
    }
    model_pp_taint(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, random_seed__, pstream__);
    }
    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning
        current_statement_begin__ = -1;
        static const char* function__ = "model_pp_taint_namespace::model_pp_taint";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        try {
            // initialize data block variables from context__
            current_statement_begin__ = 17;
            context__.validate_dims("data initialization", "S", "int", context__.to_vec());
            S = int(0);
            vals_i__ = context__.vals_i("S");
            pos__ = 0;
            S = vals_i__[pos__++];
            check_greater_or_equal(function__, "S", S, 1);
            current_statement_begin__ = 18;
            context__.validate_dims("data initialization", "n", "int", context__.to_vec());
            n = int(0);
            vals_i__ = context__.vals_i("n");
            pos__ = 0;
            n = vals_i__[pos__++];
            check_greater_or_equal(function__, "n", n, 0);
            current_statement_begin__ = 19;
            validate_non_negative_index("s", "n", n);
            context__.validate_dims("data initialization", "s", "int", context__.to_vec(n));
            s = std::vector<int>(n, int(0));
            vals_i__ = context__.vals_i("s");
            pos__ = 0;
            size_t s_k_0_max__ = n;
            for (size_t k_0__ = 0; k_0__ < s_k_0_max__; ++k_0__) {
                s[k_0__] = vals_i__[pos__++];
            }
            size_t s_i_0_max__ = n;
            for (size_t i_0__ = 0; i_0__ < s_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "s[i_0__]", s[i_0__], 1);
            }
            current_statement_begin__ = 20;
            validate_non_negative_index("t", "n", n);
            context__.validate_dims("data initialization", "t", "double", context__.to_vec(n));
            t = std::vector<double>(n, double(0));
            vals_r__ = context__.vals_r("t");
            pos__ = 0;
            size_t t_k_0_max__ = n;
            for (size_t k_0__ = 0; k_0__ < t_k_0_max__; ++k_0__) {
                t[k_0__] = vals_r__[pos__++];
            }
            size_t t_i_0_max__ = n;
            for (size_t i_0__ = 0; i_0__ < t_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "t[i_0__]", t[i_0__], 0);
                check_less_or_equal(function__, "t[i_0__]", t[i_0__], 1);
            }
            current_statement_begin__ = 21;
            context__.validate_dims("data initialization", "alpha", "double", context__.to_vec());
            alpha = double(0);
            vals_r__ = context__.vals_r("alpha");
            pos__ = 0;
            alpha = vals_r__[pos__++];
            check_greater_or_equal(function__, "alpha", alpha, 0);
            current_statement_begin__ = 22;
            context__.validate_dims("data initialization", "beta", "double", context__.to_vec());
            beta = double(0);
            vals_r__ = context__.vals_r("beta");
            pos__ = 0;
            beta = vals_r__[pos__++];
            check_greater_or_equal(function__, "beta", beta, 0);
            current_statement_begin__ = 23;
            context__.validate_dims("data initialization", "beta_prior", "int", context__.to_vec());
            beta_prior = int(0);
            vals_i__ = context__.vals_i("beta_prior");
            pos__ = 0;
            beta_prior = vals_i__[pos__++];
            current_statement_begin__ = 24;
            context__.validate_dims("data initialization", "gamma_prior", "int", context__.to_vec());
            gamma_prior = int(0);
            vals_i__ = context__.vals_i("gamma_prior");
            pos__ = 0;
            gamma_prior = vals_i__[pos__++];
            current_statement_begin__ = 25;
            context__.validate_dims("data initialization", "normal_prior", "int", context__.to_vec());
            normal_prior = int(0);
            vals_i__ = context__.vals_i("normal_prior");
            pos__ = 0;
            normal_prior = vals_i__[pos__++];
            current_statement_begin__ = 26;
            context__.validate_dims("data initialization", "uniform_prior", "int", context__.to_vec());
            uniform_prior = int(0);
            vals_i__ = context__.vals_i("uniform_prior");
            pos__ = 0;
            uniform_prior = vals_i__[pos__++];
            current_statement_begin__ = 27;
            context__.validate_dims("data initialization", "cauchy_prior", "int", context__.to_vec());
            cauchy_prior = int(0);
            vals_i__ = context__.vals_i("cauchy_prior");
            pos__ = 0;
            cauchy_prior = vals_i__[pos__++];
            current_statement_begin__ = 28;
            context__.validate_dims("data initialization", "t_prior", "int", context__.to_vec());
            t_prior = int(0);
            vals_i__ = context__.vals_i("t_prior");
            pos__ = 0;
            t_prior = vals_i__[pos__++];
            current_statement_begin__ = 29;
            context__.validate_dims("data initialization", "chisq_prior", "int", context__.to_vec());
            chisq_prior = int(0);
            vals_i__ = context__.vals_i("chisq_prior");
            pos__ = 0;
            chisq_prior = vals_i__[pos__++];
            current_statement_begin__ = 30;
            context__.validate_dims("data initialization", "exponential_prior", "int", context__.to_vec());
            exponential_prior = int(0);
            vals_i__ = context__.vals_i("exponential_prior");
            pos__ = 0;
            exponential_prior = vals_i__[pos__++];
            current_statement_begin__ = 31;
            context__.validate_dims("data initialization", "use_likelihood", "int", context__.to_vec());
            use_likelihood = int(0);
            vals_i__ = context__.vals_i("use_likelihood");
            pos__ = 0;
            use_likelihood = vals_i__[pos__++];
            // initialize transformed data variables
            // execute transformed data statements
            // validate transformed data
            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 34;
            num_params_r__ += 1;
            current_statement_begin__ = 35;
            num_params_r__ += 1;
            current_statement_begin__ = 36;
            validate_non_negative_index("alpha_s", "S", S);
            num_params_r__ += S;
            current_statement_begin__ = 37;
            num_params_r__ += 1;
            current_statement_begin__ = 38;
            num_params_r__ += 1;
            current_statement_begin__ = 39;
            validate_non_negative_index("xi_s", "S", S);
            num_params_r__ += S;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    ~model_pp_taint() { }
    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        typedef double local_scalar_t__;
        stan::io::writer<double> writer__(params_r__, params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;
        current_statement_begin__ = 34;
        if (!(context__.contains_r("theta")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable theta missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("theta");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "theta", "double", context__.to_vec());
        double theta(0);
        theta = vals_r__[pos__++];
        try {
            writer__.scalar_lub_unconstrain(0, 1, theta);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable theta: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 35;
        if (!(context__.contains_r("sigma")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable sigma missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("sigma");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "sigma", "double", context__.to_vec());
        double sigma(0);
        sigma = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0, sigma);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable sigma: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 36;
        if (!(context__.contains_r("alpha_s")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable alpha_s missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("alpha_s");
        pos__ = 0U;
        validate_non_negative_index("alpha_s", "S", S);
        context__.validate_dims("parameter initialization", "alpha_s", "vector_d", context__.to_vec(S));
        Eigen::Matrix<double, Eigen::Dynamic, 1> alpha_s(S);
        size_t alpha_s_j_1_max__ = S;
        for (size_t j_1__ = 0; j_1__ < alpha_s_j_1_max__; ++j_1__) {
            alpha_s(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(alpha_s);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable alpha_s: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 37;
        if (!(context__.contains_r("mu")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable mu missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("mu");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "mu", "double", context__.to_vec());
        double mu(0);
        mu = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0, mu);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable mu: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 38;
        if (!(context__.contains_r("rho")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable rho missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("rho");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "rho", "double", context__.to_vec());
        double rho(0);
        rho = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0, rho);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable rho: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 39;
        if (!(context__.contains_r("xi_s")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable xi_s missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("xi_s");
        pos__ = 0U;
        validate_non_negative_index("xi_s", "S", S);
        context__.validate_dims("parameter initialization", "xi_s", "vector_d", context__.to_vec(S));
        Eigen::Matrix<double, Eigen::Dynamic, 1> xi_s(S);
        size_t xi_s_j_1_max__ = S;
        for (size_t j_1__ = 0; j_1__ < xi_s_j_1_max__; ++j_1__) {
            xi_s(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lb_unconstrain(0, xi_s);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable xi_s: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }
    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }
    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(std::vector<T__>& params_r__,
                 std::vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {
        typedef T__ local_scalar_t__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // dummy to suppress unused var warning
        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;
        try {
            stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
            // model parameters
            current_statement_begin__ = 34;
            local_scalar_t__ theta;
            (void) theta;  // dummy to suppress unused var warning
            if (jacobian__)
                theta = in__.scalar_lub_constrain(0, 1, lp__);
            else
                theta = in__.scalar_lub_constrain(0, 1);
            current_statement_begin__ = 35;
            local_scalar_t__ sigma;
            (void) sigma;  // dummy to suppress unused var warning
            if (jacobian__)
                sigma = in__.scalar_lb_constrain(0, lp__);
            else
                sigma = in__.scalar_lb_constrain(0);
            current_statement_begin__ = 36;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> alpha_s;
            (void) alpha_s;  // dummy to suppress unused var warning
            if (jacobian__)
                alpha_s = in__.vector_constrain(S, lp__);
            else
                alpha_s = in__.vector_constrain(S);
            current_statement_begin__ = 37;
            local_scalar_t__ mu;
            (void) mu;  // dummy to suppress unused var warning
            if (jacobian__)
                mu = in__.scalar_lb_constrain(0, lp__);
            else
                mu = in__.scalar_lb_constrain(0);
            current_statement_begin__ = 38;
            local_scalar_t__ rho;
            (void) rho;  // dummy to suppress unused var warning
            if (jacobian__)
                rho = in__.scalar_lb_constrain(0, lp__);
            else
                rho = in__.scalar_lb_constrain(0);
            current_statement_begin__ = 39;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> xi_s;
            (void) xi_s;  // dummy to suppress unused var warning
            if (jacobian__)
                xi_s = in__.vector_lb_constrain(0, S, lp__);
            else
                xi_s = in__.vector_lb_constrain(0, S);
            // transformed parameters
            current_statement_begin__ = 42;
            validate_non_negative_index("theta_s", "S", S);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> theta_s(S);
            stan::math::initialize(theta_s, DUMMY_VAR__);
            stan::math::fill(theta_s, DUMMY_VAR__);
            current_statement_begin__ = 43;
            validate_non_negative_index("kappa_s", "S", S);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> kappa_s(S);
            stan::math::initialize(kappa_s, DUMMY_VAR__);
            stan::math::fill(kappa_s, DUMMY_VAR__);
            // transformed parameters block statements
            current_statement_begin__ = 44;
            stan::math::assign(theta_s, inv_logit(add(logit(theta), multiply(sigma, alpha_s))));
            current_statement_begin__ = 45;
            stan::math::assign(kappa_s, add(mu, multiply(rho, xi_s)));
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 42;
            size_t theta_s_j_1_max__ = S;
            for (size_t j_1__ = 0; j_1__ < theta_s_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(theta_s(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: theta_s" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable theta_s: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            check_greater_or_equal(function__, "theta_s", theta_s, 0);
            check_less_or_equal(function__, "theta_s", theta_s, 1);
            current_statement_begin__ = 43;
            size_t kappa_s_j_1_max__ = S;
            for (size_t j_1__ = 0; j_1__ < kappa_s_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(kappa_s(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: kappa_s" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable kappa_s: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            check_greater_or_equal(function__, "kappa_s", kappa_s, 0);
            // model body
            current_statement_begin__ = 48;
            if (as_bool(beta_prior)) {
                current_statement_begin__ = 49;
                lp_accum__.add(beta_log<propto__>(theta, alpha, beta));
            } else if (as_bool(gamma_prior)) {
                current_statement_begin__ = 51;
                lp_accum__.add(gamma_log<propto__>(theta, alpha, beta));
            } else if (as_bool(normal_prior)) {
                current_statement_begin__ = 53;
                lp_accum__.add(normal_log<propto__>(theta, alpha, beta));
            } else if (as_bool(uniform_prior)) {
                current_statement_begin__ = 55;
                lp_accum__.add(uniform_log<propto__>(theta, alpha, beta));
            } else if (as_bool(cauchy_prior)) {
                current_statement_begin__ = 57;
                lp_accum__.add(cauchy_log<propto__>(theta, alpha, beta));
            } else if (as_bool(t_prior)) {
                current_statement_begin__ = 59;
                lp_accum__.add(student_t_log<propto__>(theta, alpha, 0, 1));
            } else if (as_bool(chisq_prior)) {
                current_statement_begin__ = 61;
                lp_accum__.add(chi_square_log<propto__>(theta, alpha));
            } else if (as_bool(exponential_prior)) {
                current_statement_begin__ = 63;
                lp_accum__.add(exponential_log<propto__>(theta, alpha));
            }
            current_statement_begin__ = 65;
            lp_accum__.add(normal_log<propto__>(sigma, 0, 1));
            current_statement_begin__ = 66;
            lp_accum__.add(normal_log<propto__>(alpha_s, 0, 1));
            current_statement_begin__ = 67;
            lp_accum__.add(normal_log<propto__>(mu, 0, 100));
            current_statement_begin__ = 68;
            lp_accum__.add(normal_log<propto__>(rho, 0, 1));
            current_statement_begin__ = 69;
            lp_accum__.add(normal_log<propto__>(xi_s, 0, 1));
            current_statement_begin__ = 70;
            if (as_bool(use_likelihood)) {
                current_statement_begin__ = 71;
                for (int i = 1; i <= n; ++i) {
                    current_statement_begin__ = 72;
                    lp_accum__.add(beta_proportion_log<propto__>(get_base1(t, i, "t", 1), get_base1(theta_s, get_base1(s, i, "s", 1), "theta_s", 1), get_base1(kappa_s, get_base1(s, i, "s", 1), "kappa_s", 1)));
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
        lp_accum__.add(lp__);
        return lp_accum__.sum();
    } // log_prob()
    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }
    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("theta");
        names__.push_back("sigma");
        names__.push_back("alpha_s");
        names__.push_back("mu");
        names__.push_back("rho");
        names__.push_back("xi_s");
        names__.push_back("theta_s");
        names__.push_back("kappa_s");
    }
    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(S);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(S);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(S);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(S);
        dimss__.push_back(dims__);
    }
    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;
        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
        static const char* function__ = "model_pp_taint_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        double theta = in__.scalar_lub_constrain(0, 1);
        vars__.push_back(theta);
        double sigma = in__.scalar_lb_constrain(0);
        vars__.push_back(sigma);
        Eigen::Matrix<double, Eigen::Dynamic, 1> alpha_s = in__.vector_constrain(S);
        size_t alpha_s_j_1_max__ = S;
        for (size_t j_1__ = 0; j_1__ < alpha_s_j_1_max__; ++j_1__) {
            vars__.push_back(alpha_s(j_1__));
        }
        double mu = in__.scalar_lb_constrain(0);
        vars__.push_back(mu);
        double rho = in__.scalar_lb_constrain(0);
        vars__.push_back(rho);
        Eigen::Matrix<double, Eigen::Dynamic, 1> xi_s = in__.vector_lb_constrain(0, S);
        size_t xi_s_j_1_max__ = S;
        for (size_t j_1__ = 0; j_1__ < xi_s_j_1_max__; ++j_1__) {
            vars__.push_back(xi_s(j_1__));
        }
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        if (!include_tparams__ && !include_gqs__) return;
        try {
            // declare and define transformed parameters
            current_statement_begin__ = 42;
            validate_non_negative_index("theta_s", "S", S);
            Eigen::Matrix<double, Eigen::Dynamic, 1> theta_s(S);
            stan::math::initialize(theta_s, DUMMY_VAR__);
            stan::math::fill(theta_s, DUMMY_VAR__);
            current_statement_begin__ = 43;
            validate_non_negative_index("kappa_s", "S", S);
            Eigen::Matrix<double, Eigen::Dynamic, 1> kappa_s(S);
            stan::math::initialize(kappa_s, DUMMY_VAR__);
            stan::math::fill(kappa_s, DUMMY_VAR__);
            // do transformed parameters statements
            current_statement_begin__ = 44;
            stan::math::assign(theta_s, inv_logit(add(logit(theta), multiply(sigma, alpha_s))));
            current_statement_begin__ = 45;
            stan::math::assign(kappa_s, add(mu, multiply(rho, xi_s)));
            if (!include_gqs__ && !include_tparams__) return;
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 42;
            check_greater_or_equal(function__, "theta_s", theta_s, 0);
            check_less_or_equal(function__, "theta_s", theta_s, 1);
            current_statement_begin__ = 43;
            check_greater_or_equal(function__, "kappa_s", kappa_s, 0);
            // write transformed parameters
            if (include_tparams__) {
                size_t theta_s_j_1_max__ = S;
                for (size_t j_1__ = 0; j_1__ < theta_s_j_1_max__; ++j_1__) {
                    vars__.push_back(theta_s(j_1__));
                }
                size_t kappa_s_j_1_max__ = S;
                for (size_t j_1__ = 0; j_1__ < kappa_s_j_1_max__; ++j_1__) {
                    vars__.push_back(kappa_s(j_1__));
                }
            }
            if (!include_gqs__) return;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng, params_r_vec, params_i_vec, vars_vec, include_tparams, include_gqs, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }
    std::string model_name() const {
        return "model_pp_taint";
    }
    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "theta";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma";
        param_names__.push_back(param_name_stream__.str());
        size_t alpha_s_j_1_max__ = S;
        for (size_t j_1__ = 0; j_1__ < alpha_s_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "alpha_s" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "rho";
        param_names__.push_back(param_name_stream__.str());
        size_t xi_s_j_1_max__ = S;
        for (size_t j_1__ = 0; j_1__ < xi_s_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "xi_s" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t theta_s_j_1_max__ = S;
            for (size_t j_1__ = 0; j_1__ < theta_s_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "theta_s" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t kappa_s_j_1_max__ = S;
            for (size_t j_1__ = 0; j_1__ < kappa_s_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "kappa_s" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__) return;
    }
    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "theta";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma";
        param_names__.push_back(param_name_stream__.str());
        size_t alpha_s_j_1_max__ = S;
        for (size_t j_1__ = 0; j_1__ < alpha_s_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "alpha_s" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "rho";
        param_names__.push_back(param_name_stream__.str());
        size_t xi_s_j_1_max__ = S;
        for (size_t j_1__ = 0; j_1__ < xi_s_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "xi_s" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t theta_s_j_1_max__ = S;
            for (size_t j_1__ = 0; j_1__ < theta_s_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "theta_s" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t kappa_s_j_1_max__ = S;
            for (size_t j_1__ = 0; j_1__ < kappa_s_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "kappa_s" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__) return;
    }
}; // model
}  // namespace
typedef model_pp_taint_namespace::model_pp_taint stan_model;
#ifndef USING_R
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
#endif
#endif
