% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/suspicious_env_outliers.R
\name{suspicious_env_outliers}
\alias{suspicious_env_outliers}
\title{Function to detect suspicious outliers based on environmental variables.}
\usage{
suspicious_env_outliers(
  occ,
  occ_crs = 4326,
  variables,
  rm_outliers = FALSE,
  seed = 10L,
  ...,
  visualize = TRUE
)
}
\arguments{
\item{occ}{(\code{data.frame}, \code{sf}, \code{SpatialPointsDataFrame})
The occurrence dataset for training.
There must be column \code{x} and \code{y} for coordinates if it is a regular \code{data.frame}.}

\item{occ_crs}{(\code{numeric} or \code{\link{crs}}) The EPSG number or
\code{\link{crs}} object of occurrence CRS.
The default value is \code{4326}, which is the geographic coordinate system.}

\item{variables}{(\code{RasterStack} or \code{stars}) The stack of environmental variables.}

\item{rm_outliers}{(\code{logical}) The option to remove the suspicious outliers or not.
The default is \code{FALSE}.}

\item{seed}{(\code{integer}) The random seed used in the modeling. It should be an
integer. The default is \code{10L}.}

\item{...}{Other arguments passed to function \code{\link{outlier.tree}} in
package \code{outliertree}.}

\item{visualize}{(\code{logical}) If \code{TRUE}, plot the result.
The default is \code{TRUE}.}
}
\value{
(\code{EnvironmentalOutlier}) A list that contains
\itemize{
\item{outliers (\code{\link{sf}}) The \code{\link{sf}} points of outliers}
\item{outlier_details (\code{tibble}) A table of outlier details returned from
function \code{\link{outlier.tree}} in package \code{outliertree}}
\item{pts_occ (\code{\link{sf}}) The \code{\link{sf}} points of occurrence.
If \code{rm_outliers} is \code{TRUE}, outliers are deleted from points of
occurrence. If \code{FALSE}, the full observations are returned.}}
}
\description{
Run \code{\link{outlier.tree}} to detect suspicious outliers in observations.
}
\details{
Please check more details in R documentation of function
\code{\link{outlier.tree}} in package \code{outliertree} and their GitHub.
}
\examples{
library(dplyr)
library(sf)
library(stars)
library(itsdm)

data("occ_virtual_species")
env_vars <- system.file(
  'extdata/bioclim_tanzania_10min.tif',
  package = 'itsdm') \%>\% read_stars() \%>\%
  slice('band', c(1, 5, 12))

occ_outliers <- suspicious_env_outliers(
  occ = occ_virtual_species, variables = env_vars,
  z_outlier = 3.5, outliers_print = 4L, nthreads = 1)

occ_outliers
plot(occ_outliers)

}
\references{
\itemize{
\item{\href{https://arxiv.org/abs/2001.00636}{Cortes, David. "Explainable
outlier detection through decision tree conditioning."
\emph{arXiv preprint arXiv:2001.00636} (2020).}}
\item{\url{https://github.com/david-cortes/outliertree}}}
}
\seealso{
\code{\link{print.EnvironmentalOutlier}}, \code{\link{plot.EnvironmentalOutlier}}
\code{\link{outlier.tree}} in package \code{outliertree}
}
