% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pk_methods_get_status.R
\name{get_status.pk}
\alias{get_status.pk}
\title{Check status of a `pk` object}
\usage{
\method{get_status}{pk}(obj, suppress.messages = NULL, ...)
}
\arguments{
\item{obj}{A `pk` object}

\item{suppress.messages}{Logical. Whether to display messages.}

\item{...}{Additional arguments.}
}
\value{
The status of the `pk` object as an integer.
}
\description{
Check status of a `pk` object
}
\details{
`pk` objects have integer statuses reflecting what stage of the analysis
process they are at.

1. Object has been initialized
2. Data pre-processing complete
3. Model pre-fitting complete 4
. Model fitting complete

If a `pk` object of status 2 or greater has its instructions modified with
`+`, then its status will be reset to 1, indicating that any analysis results
contained in the object are now outdated and all steps of the analysis need
to be re-run.

This function allows the user to check the status of a `pk` object.

A message will be printed listing the analysis steps that have been completed
for this `pk` object, and the integer status will be returned.
}
\author{
Caroline Ring
}
