% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_params_2comp.R
\name{check_params_2comp}
\alias{check_params_2comp}
\title{Check 2-compartment model parameters}
\usage{
check_params_2comp(params, route, medium, ...)
}
\arguments{
\item{params}{A named numeric vector of parameters for the 2-compartment model.}

\item{route}{A character vector of routes: "iv" and/or "oral".}

\item{medium}{A character vector of tissue media: "plasma" and/or "blood".}

\item{...}{Additional arguments (not currently used)}
}
\value{
Character: A message. If all required parameters are present for the
  given media & routes, the message is "Parameters OK". If required
  parameters for the oral route are missing, the message is "Error: For
  2-compartment oral model, missing parameters (comma-separated list of
  parameter names)".  If required
  parameters for the IV route are missing, the message is "Error: For
  2-compartment oral model, missing parameters (comma-separated list of
  parameter names)".
}
\description{
Check to make sure required parameters are present to evaluate 2-compartment
model for a given route and medium
}
\author{
Caroline Ring
}
