% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/describe_aggregated_profiles.R,
%   R/describe_ceteris_paribus.R, R/describe_feature_importance.R
\name{describe.partial_dependency_explainer}
\alias{describe.partial_dependency_explainer}
\alias{describe}
\alias{describe.ceteris_paribus_explainer}
\alias{describe.feature_importance_explainer}
\title{Natural language description of feature importance explainer}
\usage{
\method{describe}{partial_dependency_explainer}(x,
  nonsignificance_treshold = 0.15, ..., display_values = FALSE,
  display_numbers = FALSE, variables = NULL, label = "prediction")

describe(x, ...)

\method{describe}{ceteris_paribus_explainer}(x,
  nonsignificance_treshold = 0.15, ..., display_values = FALSE,
  display_numbers = FALSE, variables = NULL, label = "prediction")

\method{describe}{feature_importance_explainer}(x,
  nonsignificance_treshold = 0.15, ...)
}
\arguments{
\item{x}{a ceteris paribus explanation produced with function \code{ceteris_paribus()}}

\item{nonsignificance_treshold}{a parameter specifying a treshold for variable importance}

\item{...}{other arguments}

\item{display_values}{allows for displaying variable values}

\item{display_numbers}{allows for displaying numerical values}

\item{variables}{a character of a single variable name to be described}

\item{label}{label for model's prediction}
}
\description{
Generic function \code{describe} generates a natural language
description of \code{ceteris_paribus()}, \code{aggregated_profiles()} and
\code{feature_importance()} explanations what enchaces their interpretability.
}
\details{
Function \code{describe.ceteris_paribus()} generates a natural language description of
ceteris paribus profile. The description summarizes variable values, that would change
model's prediction at most. If a ceteris paribus profile for multiple variables is passed,
\code{variables} must specify a single variable to be described. Works only for a ceteris paribus profile
for one observation. In current version only categorical values are discribed. For \code{display_numbers = TRUE}
three most important variable values are displayed, while \code{display_numbers = FALSE} displays
all the important variables, however without further details.

Function \code{describe.ceteris_paribus()} generates a natural language description of
ceteris paribus profile. The description summarizes variable values, that would change
model's prediction at most. If a ceteris paribus profile for multiple variables is passed,
\code{variables} must specify a single variable to be described. Works only for a ceteris paribus profile
for one observation. For \code{display_numbers = TRUE}
three most important variable values are displayed, while \code{display_numbers = FALSE} displays
all the important variables, however without further details.

Function \code{describe.feature_importance_explainer()} generates a natural language
description of feature importance explanation. It prints the number of important variables, that
have significant dropout difference from the full model, depending on \code{nonsignificance_treshold}.
The description prints the three most important variables for the model's prediction.
The current design of DALEX explainer does not allow for displaying variables values.
}
\examples{
library("DALEX")
library("randomForest")

titanic <- na.omit(titanic)
\donttest{
model_titanic_rf <- randomForest(survived == "yes" ~ gender + age + class + embarked +
                                  fare + sibsp + parch,  data = titanic)
explain_titanic_rf <- explain(model_titanic_rf,
                             data = titanic[,-9],
                             y = titanic$survived == "yes",
                             label = "rf")

selected_passangers <- select_sample(titanic, n = 10)
cp_rf <- ceteris_paribus(explain_titanic_rf, selected_passangers)
pdp <- aggregate_profiles(cp_rf, type = "partial", variable_type = "categorical")
describe(pdp, variables = "gender")
}
library("DALEX")
library("ingredients")
library("randomForest")
titanic <- na.omit(titanic)
\donttest{
model_titanic_rf <- randomForest(survived == "yes" ~ gender + age + class + embarked +
                                 fare + sibsp + parch,  data = titanic)
explain_titanic_rf <- explain(model_titanic_rf,
                              data = titanic[,-9],
                              y = titanic$survived == "yes",
                              label = "rf")

selected_passanger <- select_sample(titanic, n = 1, seed = 123)
cp_rf <- ceteris_paribus(explain_titanic_rf, selected_passanger)

plot(cp_rf, variable_type = "categorical")
describe(cp_rf, variables = "class", label = "the predicted probability")
}
library("DALEX")
library("ingredients")

lm_model <- lm(m2.price~., data = apartments)
explainer_lm <- explain(lm_model, data = apartments[,2:6],
                        y = apartments$m2.price, label="lm")
fi_lm <- feature_importance(explainer_lm, loss_function = loss_root_mean_square)

plot(fi_lm)
describe(fi_lm)

}
