#' Methods for causal inference with interference
#' 
#' Interference occurs when the treatment of one unit affects outcomes of other
#' units. This package provides methods for estimating causal effects in the 
#' presence of interference. Currently it implements the IPW estimators 
#' proposed by \href{http://dx.doi.org/10.1177/0962280210386779}{Tchetgen Tchetgen and Vanderweele (2012)}
#' and developed further in \href{http://dx.doi.org/10.1111/biom.12184}{Heydrich-Perez et al. (2014)}.
#' 
#' @name inferference
#' @references Saul, B. and Hugdens, M. G. (2017). 
#' A Recipe for {inferference}: {S}tart with Causal Inference. {A}dd Interference. {M}ix Well with {R}. 
#' Journal of Statistical Software, 82(2), 1-21. \href{http://dx.doi.org/10.18637/jss.v082.i02}{doi:10.18637/jss.v082.i02}
#' 
#' @docType package
NULL
