% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{threshold}
\alias{threshold}
\title{Threshold grayscale image}
\usage{
threshold(im, thr = "auto", approx = TRUE, adjust = 1)
}
\arguments{
\item{im}{the image}

\item{thr}{a threshold, either numeric, or "auto", or a string for quantiles}

\item{approx}{Skip pixels when computing quantiles in large images (default TRUE)}

\item{adjust}{use to adjust the automatic threshold: if the auto-threshold is at k, effective threshold will be at adjust*k (default 1)}
}
\value{
a pixset with the selected pixels
}
\description{
Thresholding corresponding to setting all values below a threshold to 0, all above to 1.
If you call threshold with thr="auto" a threshold will be computed automatically using kmeans (ie., using a variant of Otsu's method).
This works well if the pixel values have a clear bimodal distribution. If you call threshold with a string argument of the form "XX\%" (e.g., "98\%"), the threshold will be set at percentile XX.
Computing quantiles or running kmeans is expensive for large images, so if approx == TRUE threshold will skip pixels if the total number of pixels is above 10,000. Note that thresholding a colour image will threshold all the colour channels jointly, which may not be the desired behaviour! Use iiply(im,"c",threshold) to find optimal values for each channel separately.
}
\examples{
\dontshow{cimg.limit.openmp()}
im <- load.example("birds")
im.g <- grayscale(im)
threshold(im.g,"15\%") \%>\% plot
threshold(im.g,"auto") \%>\% plot
threshold(im.g,.1) \%>\% plot
#If auto-threshold is too high, adjust downwards or upwards
#using "adjust"
threshold(im,adjust=.5) \%>\% plot
threshold(im,adjust=1.3) \%>\% plot
}
\author{
Simon Barthelme
}
