% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conversions.R
\name{as.cimg.data.frame}
\alias{as.cimg.data.frame}
\title{Create an image from a data.frame}
\usage{
\method{as.cimg}{data.frame}(obj, v.name = "value", dims, ...)
}
\arguments{
\item{obj}{a data.frame}

\item{v.name}{name of the variable to extract pixel values from (default "value")}

\item{dims}{a vector of length 4 corresponding to image dimensions. If missing, a guess will be made.}

\item{...}{ignored}
}
\value{
an object of class cimg
}
\description{
This function is meant to be just like as.cimg.data.frame, but in reverse. Each line in the data frame must correspond to a pixel. For example, the data fame can be of the form (x,y,value) or (x,y,z,value), or (x,y,z,cc,value). The coordinates must be valid image coordinates (i.e., positive integers).
}
\examples{
#Create a data.frame with columns x,y and value
df <- expand.grid(x=1:10,y=1:10) \%>\% dplyr::mutate(value=x*y)
#Convert to cimg object (2D, grayscale image of size 10*10
as.cimg(df,dims=c(10,10,1,1)) \%>\% plot
}
\author{
Simon Barthelme
}
