% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/iNEXT.r
\name{ggiNEXT}
\alias{ggiNEXT}
\title{ggplot2 extension for an iNEXT Object}
\usage{
ggiNEXT(x, type = 1, se = TRUE, facet.var = "none", color.var = "order")
}
\arguments{
\item{x}{a \code{iNEXT} object computed by \code{\link{iNEXT}}}

\item{type}{three different plotting \code{type = c(1, 2, 3)}; \code{1} means to plot number of individuals or number of samples to diversity;
\code{2} means to plot number of individuals or number of samples to sample coverage; and \code{3} means to plot sample coverage to diversity.}

\item{se}{display confidence interval around estimated accumulation curve}

\item{facet.var}{display subsets of the dataset in different panels with four choices: \code{facet.var = c("none", "order", "site", "both")} where \code{"none"} means do not split any lay out panels in a grid; \code{"order"} means split lay out panels by different orders q; \code{"site"} means split lay out panels by different sites; and \code{"both"} means split lay out panels by order and sites.}

\item{color.var}{display subsets of the dataset in different colors with four choices: \code{color.var = c("none", "order", "site", "both")} where \code{"none"} means do not split any color; \code{"order"} means split colors by different orders q; \code{"site"} means split colors by different sites; and \code{"both"} means split colors by order and sites.}
}
\value{
a ggplot object
}
\description{
\code{ggiNEXT} the \code{\link{ggplot2}} extension for \code{\link{iNEXT}} Object
}
\examples{
data(spider)
# single abundance-based data
out1 <- iNEXT(spider$Girdled, q=0, datatype="abundance")
ggiNEXT(x=out1, type=1)
ggiNEXT(x=out1, type=2)
ggiNEXT(x=out1, type=3)

\dontrun{
# single incidence-based data with multiple order q
data(ant)
size <- round(seq(10, 500, length.out=20))
y <- iNEXT(ant$h500m, q=c(0,1,2), datatype="incidence", size=size, se=FALSE)
ggiNEXT(y, se=FALSE)

# multiple abundance-based data with multiple order q
z <- iNEXT(spider, q=c(0,1,2), datatype="abundance")
ggiNEXT(z, facet.var="site", color.var="order")
ggiNEXT(z, facet.var="both", color.var="both")
}
}

