% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nodr.R
\name{hwenodr}
\alias{hwenodr}
\title{Test for HWE in autopolyploids under the assumption of no double reduction}
\usage{
hwenodr(nvec)
}
\arguments{
\item{nvec}{A vector containing the observed genotype counts,
where \code{nvec[[i]]} is the number of individuals with genotype
\code{i-1}. This should be of length \code{ploidy+1}.}
}
\value{
A list with some or all of the following elements
\describe{
\item{\code{r}}{The estimated allele frequency.}
\item{\code{chisq_hwe}}{The chi-square statistic against the null of
equilibrium given no double reduction.}
\item{\code{df_hwe}}{The degrees of freedom associated with
\code{chisq_hwe}.}
\item{\code{p_hwe}}{The p-value against the null of
equilibrium given no double reduction.}
}
}
\description{
We run a likelihood ratio test against the null of no HWE, assuming that
there is no double reduction.
}
\examples{
set.seed(10)
qvec <- c(0.2, 0.3, 0.4, 0.1)
nvec <- c(stats::rmultinom(n = 1, size = 100, prob = qvec))
hwenodr(nvec = nvec)

}
\author{
David Gerard
}
