% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{gibbs_known}
\alias{gibbs_known}
\title{Gibbs sampler under random mating with known genotypes.}
\usage{
gibbs_known(x, alpha, B = 10000L, T = 1000L, more = FALSE, lg = FALSE)
}
\arguments{
\item{x}{The vector of genotype counts. x(i) is the number of
individuals that have genotype i.}

\item{alpha}{Vector of hyperparameters for the gamete frequencies.
Should be length (x.length() - 1) / 2 + 1.}

\item{B}{The number of sampling iterations.}

\item{T}{The number of burn-in iterations.}

\item{more}{A logical. Should we also return posterior draws (\code{TRUE})
or not (\code{FALSE}).}

\item{lg}{Should we return the log marginal likelihood (true) or not
(false).}
}
\value{
A list with some or all of the following elements
\itemize{
\item{\code{mx}: The estimate of the marginal likelihood}
\item{\code{p_tilde}: The value of p used to evaluate the posterior density}.
\item{\code{p}: The samples of the gamete frequencies}
\item{\code{post}: The likelihood times prior evaluated at current samples.}
\item{\code{ptilde_post}: The samples of the full conditionals of p_tilde.}
}
}
\description{
Gibbs sampler under random mating with known genotypes.
}
\author{
David Gerard
}
