% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/properties-cell.R
\name{font}
\alias{font}
\alias{font<-}
\alias{set_font}
\alias{map_font}
\title{Set the font for cell text}
\usage{
font(ht)

font(ht) <- value

set_font(ht, row, col, value)

map_font(ht, row, col, fn)
}
\arguments{
\item{ht}{A huxtable.}

\item{value}{A character vector or matrix. Set to \code{NA} to reset to the default, which is \code{NA_character_}.}

\item{row}{A row specifier. See \link{rowspecs} for details.}

\item{col}{An optional column specifier.}

\item{fn}{A mapping function. See \link{mapping-functions} for details.}
}
\description{
Set the font for cell text
}
\details{
To find out what fonts are on your system, \code{systemfonts::match_font()}
is useful.

For HTML, you can use comma-separated lists of font names like
\code{"Times New Roman, Times, Serif"}. This is not portable, though.

LaTeX and HTML use different font names. To use the same font
names across document formats, see \code{options("huxtable.latex_use_fontspec")}
in \link{huxtable-options}.
}
\examples{
font(jams) <- "times"
font(jams)

set_font(jams, "arial")
set_font(jams, 2:3, 1, "arial")
map_font(jams, by_rows("arial", "times"))

}
\seealso{
Other formatting functions: 
\code{\link{background_color}()},
\code{\link{bold}()},
\code{\link{font_size}()},
\code{\link{na_string}()},
\code{\link{number_format}()},
\code{\link{text_color}()}
}
\concept{formatting functions}
