% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/humarray.R
\name{chip.support}
\alias{chip.support}
\title{Retrieve current ChipInfo annotation object}
\usage{
chip.support(build = NULL, refresh = FALSE, alternate.file = NULL,
  warn.build = TRUE)
}
\arguments{
\item{build}{character, either "hg18", "hg19" or "hg38". Will also accept build numbers,
36, 37 or 38.}

\item{refresh}{logical, FALSE to just load whatever object is already in memory (except
when first using a function in this package, there should be a ChipInfo object loaded),
or TRUE to reload from the original source. For instance you may wish to do this when 
you want to use a different chip, different build, or if the annotation has been modifed
via a manual correction).}

\item{alternate.file}{character, name of an alternative RData file containing a ChipInfo
object to use instead of the object found in getOption("chip.info"). This will replace
the current ChipInfo object.}

\item{warn.build}{logical, whether to warn if the 'build' argument does not match
the current value of getOption("ucsc"). The default is to display this warning,
but if you set this argument to FALSE this can be suppressed.}
}
\value{
returns the current ChipInfo object [S4]. This may be slow first time, but
subsequent lookups should be much faster. Builds 36/38 are not stored explicitly so
will take a little while to convert the first time, but subsequent lookups should be
fast. To increase the speed save the object locally and use option(chip.info=<PATH>)
to set a custom path for future chip.support() calls [which are also made internally
by many of the function in this package]. This is also the option to set if you
want to add a ChipInfo object for a different chip, e.g, metabochip, exomechip, etc.
}
\description{
This function returns the current 'ChipInfo' annotation object, containing chromosome,
id, position, strand, 'rs' id, allele 1, allele 2 for each SNP of a microarray chip,
in either hg18 or hg19 (build 36/37) coordinates. Can also be used to update the 
current object to a new object.
This package makes extensive use of this class of annotation object for the working
microarray chip, e.g, default is ImmunoChip, but Metabochip is also built-in,
and you can also load your own annotation if using a different chip. The class
of the object used is 'ChipInfo' which is a GRanges object, modified to always
have columns for A1, A2 (alleles), rs.id, and a quality control flag. The
default display is tidier than GRanges, it has nice coersion to and frame data.frame
and indexing by chromosome using [[n]] has been added, in addition to normal [i,j]
indexing native to GRanges. A1 and A2 values are usually specific to each dataset
so for immunochip you may need to manually update these values to reflect
the allele coding in your own dataset.
}
\examples{
chip.support() # shows the current ChipInfo object (default is 'ImmunoChip' build 37)
#/donttest{
chip.support(build=36) # gives warning as hg19 version is currently loaded
chip.support(build=36,refresh=TRUE)
getOption("chip.info") # shows the object is now saved in the tmp directory for subsequent calls
chip.support(build=38,refresh=TRUE)
#}
}
\author{
Nicholas Cooper \email{nick.cooper@cimr.cam.ac.uk}
}
\seealso{
\code{\link{ChipInfo}}, \code{\link{build}}, \code{\link{rs.id}}, 
 \code{\link{QCfail}}, \code{\link{convTo36}}, 
 \code{\link{convTo37}}, \code{\link{A1}}, \code{\link{A2}}
}
\concept{
ImmunoChip MetaboChip microarray iSelect Illumina
}

