% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hurricanes.R
\name{plot_hurricane_nrg}
\alias{plot_hurricane_nrg}
\title{Download and plot essential climate data}
\usage{
plot_hurricane_nrg(dataset = get_hurricanes(), print = TRUE)
}
\arguments{
\item{dataset}{Name of the tibble generated by \code{get_hurricanes}}

\item{print}{(boolean) Display hurricane ggplot2 chart, defaults to TRUE. Use FALSE to not display chart.}
}
\value{
Invisibly returns a ggplot2 object with hurricane energy chart
}
\description{
Plots the hurricane energy data (ACE) retrieved using \code{get_hurricanes()} with ggplot2. The output ggplot2 object may be further modified.
}
\details{
\code{plot_hurricane_nrg} invisibly returns a ggplot2 object with a pre-defined hurricane energy data chart using data from \code{get_hurricanes}.
By default the chart is also displayed. Smooths using ggplot2's built-in loess smoother. Users may further modify the output ggplot2 chart.

ACE is an index that combines the number of systems, how long they existed and how intense they became. It is calculated by squaring the maximum sustained surface wind in the system every six hours that the cyclone is a Named Storm and summing it up for the season. Please refer to above website for details.
}
\examples{
\donttest{
# Fetch hurricane data:
hurricanes <- get_hurricanes()
#
# Plot output using package's built-in ggplot2 defaults
plot_hurricane_nrg(hurricanes)

# Or just call plot_hurricane_nrg(), which defaults to get_hurricanes() dataset
plot_hurricane_nrg()

p <- plot_hurricane_nrg(hurricanes, print = FALSE)
p + ggplot2::labs(title='Accumulated Cyclone Energy') }

}
\author{
Hernando Cortina, \email{hch@alum.mit.edu}
}
