% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hetTP.R
\name{predict.hetTP}
\alias{predict.hetTP}
\title{Student-t process predictions using a heterogeneous noise TP object (of class \code{hetTP})}
\usage{
\method{predict}{hetTP}(object, x, noise.var = FALSE, xprime = NULL,
  nugs.only = FALSE, ...)
}
\arguments{
\item{object}{an object of class \code{hetTP}; e.g., as returned by \code{\link[hetGP]{mleHetTP}}}

\item{x}{matrix of designs locations to predict at}

\item{noise.var}{should the variance of the latent variance process be returned?}

\item{xprime}{optional second matrix of predictive locations to obtain the predictive covariance matrix between \code{x} and \code{xprime}}

\item{nugs.only}{if TRUE, only return noise variance prediction}

\item{...}{no other argument for this method.}
}
\value{
list with elements
\itemize{
\item \code{mean}: kriging mean;
\item \code{sd2}: kriging variance (filtered, e.g. without the nugget values)
\item \code{nugs}: noise variance
\item \code{sd2_var}: (optional) kriging variance of the noise process
\item \code{cov}: (optional) predictive covariance matrix between x and xprime
}
}
\description{
Student-t process predictions using a heterogeneous noise TP object (of class \code{hetTP})
}
\details{
The full predictive variance corresponds to the sum of \code{sd2} and \code{nugs}.
}
