% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tparams_mean.R
\name{tparams_mean}
\alias{tparams_mean}
\title{Predicted means}
\usage{
tparams_mean(value, ...)
}
\arguments{
\item{value}{Matrix of samples from the distribution of the
mean. Columns denote random samples and rows denote means for different
observations.}

\item{...}{Arguments to pass to \link{id_attributes}. Each row in
\code{value} must be a prediction for a \code{strategy_id},
\code{patient_id}, \code{state_id}, and optionally \code{time_id} combination.}
}
\value{
An object of class \code{tparams_mean}, which is a list containing \code{value},
\code{n_samples}, and the ID attributes passed to \link{id_attributes}.
}
\description{
Create a list containing means predicted from a statistical model.
}
\note{
The \code{tparams_mean()} constructor would not normally be used by users; instead,
a \code{tparams_mean} object is typically created automatically as part of the
\code{\link{StateVals}} class with \code{\link[=create_StateVals]{create_StateVals()}}.
}
\examples{
# Setup model
hesim_dat <- hesim_data(
  strategies = data.frame(strategy_id = c(1, 2)),
  patients = data.frame(patient_id = c(1, 2)),
  states = data.frame(
    state_id = c(1, 2, 3),
    state_name = c("state1", "state2", "state3")
  )
)

# Cost model
cost_tbl <- stateval_tbl(
  data.frame(strategy_id = hesim_dat$strategies$strategy_id,
             mean = c(5000, 3000),
             se = c(200, 100)
            ),
  dist = "gamma"
)
costmod <- create_StateVals(cost_tbl, n = 2, hesim_data = hesim_dat)

# The 'params' field of the `StateVals` class is a tparams_mean object
class(costmod$params)
costmod$params
summary(costmod$params)
}
\seealso{
A \code{tparams_mean} object is a type of \link[=tparams]{transformed parameter}
object and is a supported class type of the \code{params} field of the \code{\link{StateVals}}
class. See the documentation for \code{\link[=create_StateVals]{create_StateVals()}} and \code{\link[=stateval_tbl]{stateval_tbl()}}
for examples of how to create\code{StateVals} objects. Predicted means can be
summarized across parameter samples using \code{\link[=summary.tparams_mean]{summary.tparams_mean()}}.
}
