% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psm.R
\name{create_PsmCurves}
\alias{create_PsmCurves}
\alias{create_PsmCurves.flexsurvreg_list}
\alias{create_PsmCurves.params_surv_list}
\title{Create \code{PsmCurves} object}
\usage{
create_PsmCurves(object, ...)

\method{create_PsmCurves}{flexsurvreg_list}(
  object,
  input_data,
  n = 1000,
  point_estimate = FALSE,
  bootstrap = FALSE,
  est_data = NULL,
  ...
)

\method{create_PsmCurves}{params_surv_list}(object, input_data, ...)
}
\arguments{
\item{object}{Fitted survival models.}

\item{...}{Further arguments passed to or from other methods. Currently unused.}

\item{input_data}{An object of class "expanded_hesim_data" returned by 
\code{\link{expand.hesim_data}}. Must be expanded by the data tables "strategies" and
"patients".}

\item{n}{Number of random observations of the parameters to draw.}

\item{point_estimate}{If \code{TRUE}, then the point estimates are returned and and no samples are drawn.}

\item{bootstrap}{If TRUE, then \code{n} bootstrap replications are drawn by refitting the survival
models in \code{object} on resamples of the sample data; if FALSE, then the parameters for each survival
model are independently draw from multivariate normal distributions.}

\item{est_data}{A \code{data.table} or \code{data.frame} of estimation data 
used to fit survival models during bootstrap replications.}
}
\value{
Returns an \code{\link{R6Class}} object of class \code{\link{PsmCurves}}.
}
\description{
\code{create_PsmCurves} is a function for creating an object of class
\code{\link{PsmCurves}}.
}
\seealso{
\code{\link{PsmCurves}}
}
