% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dim.R
\name{dim.mixturecure}
\alias{dim.mixturecure}
\title{Dimension method for mixturecure objects}
\usage{
\method{dim}{mixturecure}(x)
}
\arguments{
\item{x}{An object of class \code{mixturecure}.}
}
\value{
\item{nobs}{ number of subjects in the dataset.}

\item{p_incidence}{ number of variables in the incidence portion of the model.}

\item{p_latency}{ number of variables in the latency portion of the model.}
}
\description{
Dimension method for \code{mixturecure} objects.
}
\examples{
library(survival)
withr::local_seed(1234)
temp <- generate_cure_data(n = 100, j = 10, n_true = 10, a = 1.8)
training <- temp$training
fit <- curegmifs(Surv(Time, Censor) ~ .,
  data = training, x_latency = training,
  model = "weibull", thresh = 1e-4, maxit = 2000,
  epsilon = 0.01, verbose = FALSE
)
dim(fit)
}
\keyword{methods}
