\name{dicentric}
\alias{dicentric}
\docType{data}
\title{
Radiation dose effects on chromosomal abnormality
}
\description{
An experiment was conducted to determine the effect of gamma radiation on the numbers of chromosomal abnormalities observed
}
\usage{data(dicentric)}
\format{
  A data frame with 27 observations on the following 4 variables.
  \describe{
    \item{\code{cells}}{Number of cells in hundreds}
    \item{\code{ca}}{Number of chromosomal abnormalities}
    \item{\code{doseamt}}{amount of dose in Grays}
    \item{\code{doserate}}{rate of dose in Grays/hour}
  }
}

\source{
Purott R. and Reeder E. (1976) The effect of changes in dose rate on the yield of chromosome aberrations in human lymphocytes exposed to gamma radiation. Mutation Research. 35, 437-444.
}
\references{
Frome E. and DuFrain R. (1986) Maximum Likelihood Estimation for Cytogenic Dose-Response Curves. Biometrics. 42, 73-84 and  Extending the linear model with R. Chapman & Hall/CRC Taylor & Francis Group, 2006.}
\examples{
data(dicentric)
dicentric$dosef <- factor(dicentric$doseamt)
rmod <- glm(ca ~ offset(log(cells))+log(doserate)*dosef, family=poisson,dicentric)
x <- dicentric[,4]
res <- resid(rmod)
hctest(x, res)
}
\keyword{datasets}
