% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\name{subset-variants}
\alias{subset-variants}
\alias{[,variants,missing,missing,missing-method}
\alias{[,variants,numeric,missing,missing-method}
\alias{[,variants,character,missing,missing-method}
\title{Subset a variants object}
\usage{
\S4method{[}{variants,missing,missing,missing}(x, i, j, ..., drop = FALSE)

\S4method{[}{variants,numeric,missing,missing}(x, i, j, ..., drop = FALSE)

\S4method{[}{variants,character,missing,missing}(x, i, j, ..., drop = FALSE)
}
\arguments{
\item{x}{A \linkS4class{variants} object.}

\item{i}{Position of the identifier or the name of the identifier itself.}

\item{j}{Not used.}

\item{...}{Additional arguments not used here.}

\item{drop}{Not used.}
}
\value{
A \linkS4class{variants} object.
}
\description{
You can subset \linkS4class{variants} by identifier or by position using the
\code{`[`} operator.
}
\examples{
# Subset a variants object by identifier
variants_ex01['rs4725504']

# Or by its position in table variants
variants_ex01[3]

# Keep all variants except the third
variants_ex01[-3]

}
