% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combine_terms.R
\name{combine_terms}
\alias{combine_terms}
\title{Combine terms}
\usage{
combine_terms(x, formula_update, label = NULL, quiet, ...)
}
\arguments{
\item{x}{(\code{tbl_regression})\cr
A \code{tbl_regression} object}

\item{formula_update}{(\code{formula})\cr
formula update passed to the \code{\link[stats:update]{stats::update()}}.
This updated formula is used to construct a reduced model, and is
subsequently passed to \code{\link[stats:anova]{stats::anova()}} to calculate the p-value for the
group of removed terms.  See the \code{\link[stats:update]{stats::update()}} function's \verb{formula.=}
argument for proper syntax.}

\item{label}{(\code{string})\cr
Optional string argument labeling the combined rows}

\item{quiet}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}}

\item{...}{Additional arguments passed to \link[stats:anova]{stats::anova}}
}
\value{
\code{tbl_regression} object
}
\description{
The function combines terms from a regression model, and replaces the terms
with a single row in the output table.  The p-value is calculated using
\code{\link[stats:anova]{stats::anova()}}.
}
\examples{
\dontshow{if (gtsummary:::is_pkg_installed(c('cardx', 'broom.helpers'))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Example 1 ----------------------------------
# Logistic Regression Example, LRT p-value
glm(response ~ marker + I(marker^2) + grade,
    trial[c("response", "marker", "grade")] |> na.omit(), # keep complete cases only!
    family = binomial) |>
  tbl_regression(label = grade ~ "Grade", exponentiate = TRUE) |>
  # collapse non-linear terms to a single row in output using anova
  combine_terms(
    formula_update = . ~ . - marker - I(marker^2),
    label = "Marker (non-linear terms)",
    test = "LRT"
  )
\dontshow{\}) # examplesIf}
}
\author{
Daniel D. Sjoberg
}
