% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrichment.R
\name{enrichment}
\alias{enrichment}
\title{Calculate enriched terms in a target set}
\usage{
enrichment(target, control, threshold, correction = "fdr")
}
\arguments{
\item{target}{Set of \code{\link{goldi}} output for a target set of articles.}

\item{control}{Set of \code{\link{goldi}} output for a control set of articles.}

\item{threshold}{Only investigate associations which have been founder greater than this number of times.}

\item{correction}{Correction to impliment on association P values. Users may choose any value which \code{\link[stats]{p.adjust}} may accept.}
}
\value{
A formated data.frame with three columns: terms, enrichments, and P values.
}
\description{
Given a target set of articles under question, we wish to compare the frequencies of term occurance to a control set of articles.  We set a threshold above which to investigate terms (setting this threshold higher reduces spurious associated but decreases power to identify true associations) and calculate the enrichment and the P value of association (see \code{\link{hgt}} for more details).
}
\details{
This function mimics a truncated version of the output of \href{https://bmcbioinformatics.biomedcentral.com/articles/10.1186/1471-2105-10-48}{GOrilla} by identifying and quantifying the enrichment of terms in a target set of articles. Given N articles and B associations of the given term, the enrichment of b terms in the n articles in the target set is given by \eqn{\frac{\frac{b}{n}}{\frac{B}{N}}}.
}
\references{
Eden, E., Navon, R., Steinfeld, I., Lipson, D., & Yakhini, Z. (2009). GOrilla: a tool for discovery and visualization of enriched GO terms in ranked gene lists. BMC Bioinformatics, 10(1), 1–7. http://doi.org/10.1186/1471-2105-10-48
}

