% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compositionsCompatibility.R
\name{gsi.produceV}
\alias{gsi.produceV}
\title{Create a matrix of logcontrasts and name prefix}
\usage{
gsi.produceV(
  V = NULL,
  D = nrow(V),
  orignames = rownames(V),
  giveInv = FALSE,
  prefix = NULL
)
}
\arguments{
\item{V}{either a matrix of logcontrasts or, most commonly, one of "clr", "ilr" or "alr"}

\item{D}{the number of components of the composition represented}

\item{orignames}{the names of the components}

\item{giveInv}{logical, is the inverse logcontrast matrix desired?}

\item{prefix}{the desired prefix name, if this is wished to be forced.}
}
\value{
A list with at least two elements
\enumerate{
\item \code{V} containing the final matrix of logcontrasts
\item \code{prefix}  containing the final prefix for names of transformed variables
\item \code{W} eventually, the (transposed, generalised) inverse of \code{V}, if \code{giveInv=TRUE}
}
}
\description{
Given a representation specification for compositions, this function
creates the matrix of logcontrasts and provides a suitable prefix name for naming variables.
}
\examples{
gsi.produceV("alr", D=3)
gsi.produceV("ilr", D=3, orignames = c("Ca", "K", "Na"))
gsi.produceV("alr", D=3, orignames = c("Ca", "K", "Na"), giveInv = TRUE)
}
