% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/duration.R
\name{Tupler}
\alias{Tupler}
\title{Create \code{Tupler} Object}
\usage{
Tupler(n, unit = NULL, take = unit)
}
\arguments{
\item{n}{A positive integer which indicates into how many parts to divide
a duration.}

\item{unit, take}{A duration type followed by zero to four dots, or its
corresponding duration value.}
}
\value{
A list with class \code{Tupler}.
}
\description{
Create a \code{Tupler} object. \code{Tupler} objects are used in
\code{\link[=tuplet]{tuplet()}} to create tuplets.
}
\examples{
# create a triplet quarter note
t <- Tupler(3, unit = "quarter", take = "quarter")
t

tuplet("half", t)
}
\seealso{
\code{\link[=tuplet]{tuplet()}}

\code{vignette("gm", package = "gm")} for a friendly guide to tuplets.
}
