% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gkwfit.R
\name{.fit_tmb}
\alias{.fit_tmb}
\title{Fit GKw family distributions using TMB}
\usage{
.fit_tmb(
  data,
  family,
  start,
  fixed,
  method,
  hessian,
  conf.level,
  optimizer.control,
  silent
)
}
\arguments{
\item{data}{Numeric vector with values in the (0, 1) interval.}

\item{family}{Character string specifying the distribution family.}

\item{start}{List with initial parameter values.}

\item{fixed}{List of parameters to be held fixed.}

\item{method}{Optimization method: "nlminb" or "optim".}

\item{hessian}{Logical; if TRUE, computes standard errors and covariance matrix.}

\item{conf.level}{Confidence level for intervals.}

\item{optimizer.control}{List of control parameters for the optimizer.}

\item{silent}{Logical; if TRUE, suppresses messages.}
}
\value{
List containing fit results.
}
\description{
Fit GKw family distributions using TMB
}
\keyword{internal}
