% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repo_style.R
\name{repo_style}
\alias{repo_style}
\title{Style repository with styler}
\usage{
repo_style(
  repo,
  files = c("*.R", "*.Rmd"),
  branch = "styler",
  base,
  create_pull_request = TRUE,
  draft = TRUE,
  tag_collaborators = TRUE,
  prompt = TRUE
)
}
\arguments{
\item{repo}{Character. Address of repository in "owner/name" format.}

\item{files}{Character or vector of characters. Names of .R and/or .Rmd files that styler should be applied to.}

\item{branch}{Character. Name of new branch to be created or overwritten. Default is "styler".}

\item{base}{Character. Name of branch that contains the .R and/or .Rmd files to be styled}

\item{create_pull_request}{Logical. If TRUE, a pull request is created from branch to base.}

\item{draft}{Logical. Should the pull request be created as a draft pull request? (Draft PRs cannot be merged
until allowed by the author)}

\item{tag_collaborators}{Logical. If TRUE, a message with the repository collaborators is displayed.}

\item{prompt}{Character. Prompt the user before overwriting an existing branch.}
}
\value{
The functions returns NULL invisibly.
}
\description{
\itemize{
\item \code{repo_style} implements "non-invasive pretty-printing of R source code" of .R or .Rmd files
within a repository using the \code{styler} package and adhering to \code{tidyverse} formatting guidelines.
}
}
