% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repo.R, R/repo_add_file.R,
%   R/repo_delete_file.R, R/repo_get_file.R, R/repo_get_readme.R, R/repo_ls.R,
%   R/repo_modify_file.R, R/repo_put_file.R
\name{repo_file}
\alias{repo_file}
\alias{repo_add_file}
\alias{repo_delete_file}
\alias{repo_get_file}
\alias{repo_get_readme}
\alias{repo_ls}
\alias{repo_modify_file}
\alias{repo_put_file}
\title{GitHub Repository tools - file functions}
\usage{
repo_add_file(
  repo,
  file,
  message = NULL,
  repo_folder = NULL,
  branch = NULL,
  preserve_path = FALSE,
  overwrite = FALSE
)

repo_delete_file(repo, path, message = NULL, branch = NULL)

repo_get_file(repo, path, branch = NULL, quiet = FALSE, include_details = TRUE)

repo_get_readme(repo, branch = NULL, include_details = TRUE)

repo_ls(repo, path = ".", branch = NULL, full_path = FALSE)

repo_modify_file(
  repo,
  path,
  pattern,
  content,
  method = c("replace", "before", "after"),
  all = FALSE,
  message = "Modified content",
  branch = NULL
)

repo_put_file(
  repo,
  path,
  content,
  message = NULL,
  branch = NULL,
  verbose = TRUE
)
}
\arguments{
\item{repo}{Character. Address of repository in \code{owner/name} format.}

\item{file}{Character. Local file path(s) of file or files to be added.}

\item{message}{Character. Commit message.}

\item{repo_folder}{Character. Name of folder on repository to save the file(s) to. If the folder does not exist on the repository, it will be created.}

\item{branch}{Character. Name of branch to use.}

\item{preserve_path}{Logical. Should the local relative path be preserved.}

\item{overwrite}{Logical. Should existing file or files with same name be overwritten, defaults to FALSE.}

\item{path}{Character. File's path within the repository.}

\item{quiet}{Logical. Should status messages be printed.}

\item{include_details}{Logical. Should file details be attached as attributes.

\code{repo_delete_file()}m \code{repo_modify_file()}, and \code{repo_put_file()} all invisibly
return a list containing the results of the relevant GitHub API calls.

\code{repo_ls()} returns a character vector of repo files in the given path.

\code{repo_get_file()} and \code{repo_get_readme()} return a character vector with API results
attached as attributes if \code{include_details = TRUE}}

\item{full_path}{Logical. Should the function return the full path of the files and directories.}

\item{pattern}{Character. Regex pattern.}

\item{content}{Character or raw. Content of the file.}

\item{method}{Character. Should the content \code{replace} the matched pattern or be inserted \code{before} or \code{after} the match.}

\item{all}{Character. Should all instances of the pattern be modified (\code{TRUE}) or just the first (\code{FALSE}).}

\item{verbose}{Logical. Should success / failure messages be printed}
}
\description{
\itemize{
\item \code{repo_add_file()} - Add / update files in a GitHub repository.
Note that due to delays in caching, files that have been added
very recently might not yet be displayed as existing and might accidentally
be overwritten.
\item \code{repo_delete_file()} - Delete a file from a GitHub repository
\item \code{repo_modify_file()} - Modify an existing file within a GitHub repository.
\item \code{repo_ls()} - Low level function for listing the files in a GitHub Repository
\item \code{repo_put_file()} - Low level function for adding a file to a GitHub repository
\item \code{repo_get_file()} - Low level function for retrieving the content of a file from a GitHub Repository
\item \code{repo_get_readme()} - Low level function for retrieving the content of the \code{README.md} of a GitHub Repository
}
}
\examples{
\dontrun{
repo = repo_create("ghclass-test", "repo_file_test", auto_init=TRUE)

repo_ls(repo, path = ".")

repo_get_readme(repo, include_details = FALSE)

repo_get_file(repo, ".gitignore", include_details = FALSE)

repo_modify_file(
  repo, path = "README.md", pattern = "repo_file_test",
  content = "\n\nHello world!\n", method = "after"
)

repo_get_readme(repo, include_details = FALSE)

repo_add_file(repo, file = system.file("DESCRIPTION", package="ghclass"))

repo_get_file(repo, "DESCRIPTION", include_details = FALSE)

repo_delete_file(repo, "DESCRIPTION")

repo_delete(repo, prompt=FALSE)
}

}
