% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat-density-tern.R
\docType{data}
\name{stat_density_tern}
\alias{StatDensityTern}
\alias{stat_density_tern}
\title{Density Estimate}
\usage{
stat_density_tern(mapping = NULL, data = NULL, geom = "density_tern",
  position = "identity", contour = TRUE, n = 100, h = NULL,
  na.rm = FALSE, show.legend = NA, inherit.aes = TRUE, weight = 1,
  base = "ilr", expand = c(0.5, 0.5), ...)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link{aes}} or
\code{\link{aes_}}. If specified and \code{inherit.aes = TRUE} (the
default), is combined with the default mapping at the top level of the
plot. You only need to supply \code{mapping} if there isn't a mapping
defined for the plot.}

\item{data}{A data frame. If specified, overrides the default data frame
defined at the top level of the plot.}

\item{geom}{Use to override the default connection between
\code{geom_density_2d} and \code{stat_density_2d}.}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{contour}{If \code{TRUE}, contour the results of the 2d density
estimation}

\item{n}{number of grid points in each direction}

\item{h}{Bandwidth (vector of length two) as a multiple of the best estimate, estimated using \code{\link[MASS]{bandwidth.nrd}}.}

\item{na.rm}{If \code{FALSE} (the default), removes missing values with
a warning.  If \code{TRUE} silently removes missing values.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link{borders}}.}

\item{weight}{weighting for weighted kde2d esimate, default's to 1, which is non-weighted and equivalent to the usual kde2d calculation}

\item{base}{the base transformation of the data, options include 'identity' (ie direct on the cartesian space), or 'ilr'
which means to use the isometric log ratio transformation.}

\item{expand}{Calculate on a mesh which extends beyond the grid of the plot region by this amount
If \code{NULL}, estimated using \code{\link[MASS]{bandwidth.nrd}}.}

\item{...}{other arguments passed on to \code{\link{layer}}. There are
  three types of arguments you can use here:

  \itemize{
  \item Aesthetics: to set an aesthetic to a fixed value, like
     \code{color = "red"} or \code{size = 3}.
  \item Other arguments to the layer, for example you override the
    default \code{stat} associated with the layer.
  \item Other arguments passed on to the stat.
  }}
}
\description{
Perform a 2D kernel density estimatation using kde2d and display the results with contours. This can be 
useful for dealing with overplotting. Additional weight aesthetic (see aesthetic section below) permits better weighting if desired
}
\section{Aesthetics}{

\Sexpr[results=rd,stage=build]{ggtern:::rd_aesthetics("stat", "density_tern")}
}
\examples{
#Plot Density Estimate, on isometric log ratio transformation of original data
data(Feldspar)
ggtern(Feldspar,aes(Ab,An,Or)) + 
stat_density_tern(aes(fill=..level..),geom='polygon',base='ilr')
}
\keyword{datasets}

