% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat-peaks.R
\name{stat_peaks}
\alias{stat_peaks}
\alias{stat_valleys}
\title{Find peaks and valleys.}
\usage{
stat_peaks(
  mapping = NULL,
  data = NULL,
  geom = "point",
  position = "identity",
  ...,
  span = 5,
  ignore_threshold = 0.01,
  global.threshold = ignore_threshold,
  local.threshold = NULL,
  local.reference = "median",
  strict = FALSE,
  refine.wl = FALSE,
  method = "spline",
  chroma.type = "CMF",
  label.fmt = "\%.3g",
  x.label.fmt = label.fmt,
  y.label.fmt = label.fmt,
  x.label.transform = function(x) {
     x
 },
  y.label.transform = function(x) {
     x
 },
  x.colour.transform = x.label.transform,
  na.rm = FALSE,
  show.legend = FALSE,
  inherit.aes = TRUE
)

stat_valleys(
  mapping = NULL,
  data = NULL,
  geom = "point",
  position = "identity",
  ...,
  span = 5,
  ignore_threshold = 0.01,
  global.threshold = ignore_threshold,
  local.threshold = NULL,
  local.reference = "median",
  strict = FALSE,
  refine.wl = FALSE,
  method = "spline",
  chroma.type = "CMF",
  label.fmt = "\%.3g",
  x.label.fmt = label.fmt,
  y.label.fmt = label.fmt,
  x.label.transform = function(x) {
     x
 },
  y.label.transform = function(x) {
     x
 },
  x.colour.transform = x.label.transform,
  na.rm = FALSE,
  show.legend = FALSE,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{The aesthetic mapping, usually constructed with
\code{\link[ggplot2]{aes}} or \code{\link[ggplot2]{aes_}}. Only needs to be set
at the layer level if you are overriding the plot defaults.}

\item{data}{A layer specific dataset - only needed if you want to override
the plot defaults.}

\item{geom}{The geometric object to use display the data}

\item{position}{The position adjustment to use for overlapping points
on this layer}

\item{...}{other arguments passed on to \code{\link[ggplot2]{layer}}. This can
include aesthetics whose values you want to set, not map. See
\code{\link[ggplot2]{layer}} for more details.}

\item{span}{odd positive integer A peak is defined as an element in a
sequence which is greater than all other elements within a moving window of
width \code{span} centred at that element. The default value is 5, meaning
that a peak is taller than its four nearest neighbours. \code{span = NULL}
extends the span to the whole length of \code{x}.}

\item{ignore_threshold}{Deprecated synonym for \code{global.threshold}.}

\item{global.threshold}{numeric A value belonging to class
\code{"AsIs"} is interpreted as an absolute minimum height or depth
expressed in data units. A bare \code{numeric} value (normally between 0.0
and 1.0), is interpreted as relative to the range of the data. In both
cases it sets a \emph{global} height (depth) threshold below which peaks
(valleys) are ignored. A bare negative \code{numeric} value indicates the
\emph{global} height (depth) threshold below which peaks (valleys) are be
ignored. If \code{global.threshold = NULL}, no threshold is applied and all
peaks are returned.}

\item{local.threshold}{numeric A value belonging to class \code{"AsIs"} is
interpreted as an absolute minimum height (depth) expressed in data units
relative to the within-window computed minimum (maximum) value. A bare
\code{numeric} value (normally between 0.0 and 1.0), is interpreted as
expressed in units relative to the range of the data. In both cases
\code{local.threshold} sets a \emph{local} height (depth) threshold below
which peaks (valleys) are ignored. If \code{local.threshold = NULL} or if
\code{span} spans the whole of \code{x}, no threshold is applied.}

\item{local.reference}{character One of \code{"minimum"}/\code{maximum} or
\code{"median"}. The reference used to assess the height of the peak,
either the minimum value within the window or the median of all values in
the window.}

\item{strict}{logical flag: if \code{TRUE}, an element must be strictly
greater than all other values in its window to be considered a peak.}

\item{refine.wl}{logical Flag indicating if peak or valleys locations should
be refined by fitting a function.}

\item{method}{character String with the name of a method used for peak
fitting. Currently only spline interpolation is implemented.}

\item{chroma.type}{character one of "CMF" (color matching function) or "CC"
(color coordinates) or a \code{\link[photobiology]{chroma_spct}} object.}

\item{label.fmt, x.label.fmt, y.label.fmt}{character  strings giving a format
definition for construction of character strings labels with function
\code{\link{sprintf}} from \code{x} and/or \code{y} values.}

\item{x.label.transform, y.label.transform, x.colour.transform}{function Applied
to \code{x} or \code{y} values when constructing the character labels or
computing matching colours.}

\item{na.rm}{a logical value indicating whether NA values should be
stripped before the computation proceeds.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2]{borders}}.}
}
\value{
A data frame with one row for each peak (or valley) found in the
  data. If \code{refine.wl = FALSE}, the returned rows have \code{x} and
  \code{y} matching those in a row in the input \code{data}. If
  \code{refine.wl = TRUE}, interpolation based on a fitted spline is used to
  compute new \code{x} and \code{y} values.
}
\description{
\code{stat_peaks} finds at which x positions local maxima are located. If
you want find local minima, you can use \code{stat_valleys} instead.
\strong{Axis flipping is currently not supported.}
}
\details{
These stats use \code{geom_point} by default as it is the geom most
  likely to work well in almost any situation without need of tweaking. The
  default aesthetics set by these stats allow their direct use with
  \code{geom_text}, \code{geom_label}, \code{geom_line}, \code{geom_rug},
  \code{geom_hline} and \code{geom_vline}. The formatting of the labels
  returned can be controlled by the user.

  Two tests make it possible to ignore irrelevant peaks or valleys. One test
  controlled by (\code{global.threshold}) is based on the absolute
  height/depth  of peaks/valleys and can be used in all cases to ignore
  globally low peaks and shallow valleys. A second test controlled by
  (\code{local.threshold}) is available when the window defined by `span`
  does not include all observations and can be used to ignore peaks/valleys
  that are not locally prominent. In this second approach the height/depth of
  each peak/valley is compared to a summary computed from other values within
  the window where it was found. In this second case, the reference value
  used is the summary indicated by \code{local.reference}. The values
  \code{global.threshold} and \code{local.threshold} if bare numeric are
  relative to the range of \emph{y}. Thresholds for ignoring too small peaks
  are applied after peaks are searched for, and threshold values can in some
  cases result in no peaks being displayed.
}
\note{
These stats work nicely together with geoms
  \code{geom_text_repel} and
  \code{geom_label_repel} from package
  \code{\link[ggrepel]{ggrepel}} to solve the problem of overlapping labels
  by displacing them. To discard overlapping labels use \code{check_overlap =
  TRUE} as argument to \code{geom_text}.
 By default the labels are character values suitable to be plotted as is, but
 with a suitable \code{label.fmt} labels suitable for parsing by the geoms
 (e.g. into expressions containing greek letters or super or subscripts) can
 be also easily obtained.
}
\section{Computed and copied variables in the returned data frame}{

\describe{
  \item{x}{x-value at the peak (or valley) as numeric}
  \item{y}{y-value at the peak (or valley) as numeric}
  \item{x.label}{x-value at the peak (or valley) formatted as character}
  \item{y.label}{y-value at the peak (or valley) formatted as character}
  \item{wl.color}{color definition calculated by assuming that x-values are
  wavelengths expressed in nanometres.}
  \item{BW.color}{color definition, either "black" or "white", as needed to
  ensure high contrast to \code{wl.color}.}
}
}

\section{Default aesthetics}{

Set by the statistic and available to geoms.
\describe{
  \item{label}{stat(x.label)}
  \item{xintercept}{stat(x)}
  \item{yintercept}{stat(y)}
  \item{fill}{stat(wl.color)}
}
}

\section{Required aesthetics}{

Required by the statistic and need to be set with \code{aes()}.
\describe{
  \item{x}{numeric, wavelength in nanometres}
  \item{y}{numeric, a spectral quantity}
}
}

\examples{
# ggplot() methods for spectral objects set a default mapping for x and y.

# PEAKS

ggplot(sun.spct) +
  geom_line() +
  stat_peaks()

# threshold relative to data range [0..1]
ggplot(sun.spct) +
  geom_line() +
  stat_peaks(global.threshold = 0.6) # 0.6 * range of data

# threshold in data units
ggplot(sun.spct) +
  geom_line() +
  stat_peaks(global.threshold = I(0.4))

# threshold in data units
ggplot(sun.spct, unit.out = "photon") +
  geom_line() +
  stat_peaks(global.threshold = I(2e-6)) # Q in mol m-2 s-1

# VALLEYS

ggplot(sun.spct) +
  geom_line() +
  stat_valleys()

# discard multiple maxima or minima
ggplot(sun.spct) +
  geom_line() +
  stat_valleys(strict = TRUE)

# threshold relative to data range [0..1]
ggplot(sun.spct) +
  geom_line() +
  stat_valleys(global.threshold = 0.6)

# reverse threshold relative to data range [-1..0]
ggplot(sun.spct) +
  geom_line() +
  stat_valleys(global.threshold = -0.9)

# threshold in data units using I()
ggplot(sun.spct) +
  geom_line() +
  stat_valleys(global.threshold = I(0.6), strict = TRUE)

# USING OTHER COMPUTED VALUES

# colours matching the wavelength at peaks
ggplot(sun.spct) +
  geom_line() +
  stat_peaks(span = 51, size = 2.7,
             mapping = aes(colour = after_stat(wl.colour))) +
  scale_color_identity()

# labels for local maxima
ggplot(sun.spct) +
  geom_line() +
  stat_peaks(span = 51, geom = "point", colour = "red") +
  stat_peaks(span = 51, geom = "text", colour = "red",
             vjust = -0.4, label.fmt = "\%3.2f nm")

# labels for local fitted peaks
ggplot(sun.spct) +
  geom_line() +
  stat_peaks(span = 51, geom = "point", colour = "red", refine.wl = TRUE) +
  stat_peaks(span = 51, geom = "text", colour = "red",
             vjust = -0.4, label.fmt = "\%3.2f nm",
             refine.wl = TRUE)

# fitted peaks and valleys
ggplot(sun.spct) +
  geom_line() +
  stat_peaks(span = 31, geom = "point", colour = "red", refine.wl = TRUE) +
  stat_peaks(mapping = aes(fill = after_stat(wl.colour), color = after_stat(BW.colour)),
             span = 31, geom = "label",
             size = 3, vjust = -0.2, label.fmt = "\%.4g nm",
             refine.wl = TRUE) +
  stat_valleys(span = 51, geom = "point", colour = "blue", refine.wl = TRUE) +
  stat_valleys(mapping = aes(fill = after_stat(wl.colour), color = after_stat(BW.colour)),
               span = 51, geom = "label",
               size = 3, vjust = 1.2, label.fmt = "\%.4g nm",
               refine.wl = TRUE) +
  expand_limits(y = 0.85) + # make room for label
  scale_fill_identity() +
  scale_color_identity()

}
\seealso{
\code{\link[photobiology]{find_peaks}}, which is used internally.

Other stats functions: 
\code{\link{stat_color}()},
\code{\link{stat_find_qtys}()},
\code{\link{stat_find_wls}()},
\code{\link{stat_label_peaks}()},
\code{\link{stat_spikes}()},
\code{\link{stat_wb_box}()},
\code{\link{stat_wb_column}()},
\code{\link{stat_wb_contribution}()},
\code{\link{stat_wb_hbar}()},
\code{\link{stat_wb_irrad}()},
\code{\link{stat_wb_label}()},
\code{\link{stat_wb_mean}()},
\code{\link{stat_wb_relative}()},
\code{\link{stat_wb_sirrad}()},
\code{\link{stat_wb_total}()},
\code{\link{stat_wl_strip}()},
\code{\link{stat_wl_summary}()}
}
\concept{stats functions}
