% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stl-seasonal.R
\name{stat_stl}
\alias{stat_stl}
\title{LOESS seasonal adjustment Stat}
\usage{
stat_stl(mapping = NULL, data = NULL, geom = "line",
  position = "identity", show.legend = NA, inherit.aes = TRUE, frequency,
  s.window, index.ref = NULL, index.basis = 100, ...)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link{aes}} or
\code{\link{aes_}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
   options:

   If \code{NULL}, the default, the data is inherited from the plot
   data as specified in the call to \code{\link{ggplot}}.

   A \code{data.frame}, or other object, will override the plot
   data. All objects will be fortified to produce a data frame. See
   \code{\link{fortify}} for which variables will be created.

   A \code{function} will be called with a single argument,
   the plot data. The return value must be a \code{data.frame.}, and
   will be used as the layer data.}

\item{geom}{The geometric object to use display the data}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link{borders}}.}

\item{frequency}{The frequency for the time series}

\item{s.window}{either the character string \code{"periodic"} or the span (in lags) of the 
loess window for seasonal extraction, which should be odd and at least 7, according to
Cleveland et al.  This has no default and must be chosen.}

\item{index.ref}{if not NULL, a vector of integers indicating which elements of
the beginning of each series to use as a reference point for converting to an index.  
If NULL, no conversion takes place and the data are presented on the original scale.}

\item{index.basis}{if index.ref is not NULL, the basis point for converting
to an index, most commonly 100 or 1000.  See examples.}

\item{...}{other arguments for the geom}
}
\description{
Conducts seasonal adjustment on the fly for ggplot2, from LOESS seasonal decomposition
}
\examples{
ap_df <- tsdf(AirPassengers)

# periodic if fixed seasonality; doesn't work well:
ggplot(ap_df, aes(x = x, y = y)) +
   stat_stl(frequency = 12, s.window = "periodic")

# seasonality varies a bit over time, works better:
ggplot(ap_df, aes(x = x, y = y)) +
   stat_stl(frequency = 12, s.window = 7)

# Multiple time series example:
ggplot(ldeaths_df, aes(x = YearMon, y = deaths, colour = sex)) +
   geom_point() +
   facet_wrap(~sex) +
   stat_stl(frequency = 12, s.window = 7) +
   ggtitle("Seasonally adjusted lung deaths")

# Index so first value is 100:
ggplot(ap_df, aes(x = x, y = y)) +
   stat_stl(frequency = 12, s.window = 7, index.ref = 1)
}
\seealso{
Other time.series.stats.for.ggplot2: \code{\link{stat_decomp}},
  \code{\link{stat_index}}, \code{\link{stat_rollapplyr}},
  \code{\link{stat_seas}}
}

