% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write.R
\name{write_gff3}
\alias{write_gff3}
\title{Write a gff3 file from a tidy table}
\usage{
write_gff3(
  feats,
  file,
  seqs = NULL,
  type = NULL,
  source = ".",
  score = ".",
  strand = ".",
  phase = ".",
  id_var = "feat_id",
  parent_var = "parent_ids",
  head = "##gff-version 3",
  ignore_attr = c("introns", "geom_id")
)
}
\arguments{
\item{feats}{tidy feat table}

\item{file}{name of output file}

\item{seqs}{a tidy sequence table to generate optional \verb{##sequence-region}
directives in the header}

\item{type}{if no type column exists, use this as the default type}

\item{source}{if no source column exists, use this as the default source}

\item{score}{if no score column exists, use this as the default score}

\item{strand}{if no strand column exists, use this as the default strand}

\item{phase}{if no phase column exists, use this as the default phase}

\item{id_var}{the name of the column to use as the GFF3 \code{ID} tag}

\item{parent_var}{the name of the column to use as GFF3 \code{Parent} tag}

\item{head}{additional information to add to the header section}

\item{ignore_attr}{attributes not to be included in GFF3 tag list. Defaults
to internals: \verb{introns, geom_id}}
}
\value{
No return value, writes to file
}
\description{
Write a gff3 file from a tidy table
}
\examples{
filename <- tempfile(fileext = ".gff")
write_gff3(emale_genes, filename, emale_seqs, id_var = "feat_id")
}
