% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat_waterfall.R
\name{stat_waterfall}
\alias{stat_waterfall}
\title{Plot a time series as a waterfall plot}
\usage{
stat_waterfall(mapping = NULL, data = NULL, show.legend = NA,
  inherit.aes = TRUE, na.rm = T, bandwidth = NULL, ...)
}
\arguments{
\item{mapping}{mapping}

\item{data}{data}

\item{show.legend}{legend}

\item{inherit.aes}{logical}

\item{na.rm}{logical}

\item{bandwidth}{bandwidth}

\item{...}{more functions

A waterfall plot highlights the change in the time series rather than the
value of the time series itself.}
}
\description{
Plot a time series as a waterfall plot
}
\section{Aesthetics}{
 stat_waterfall needs x, y
}

\section{Cosmetic Tips}{
 The minimalist look can be achieved by appending the
following chunk of code to the output object:
\code{
+
xlab(NULL) +
ylab(NULL) +
theme(
   axis.text = element_blank(),
   axis.ticks = element_blank(),
   legend.position = 'none',
   strip.background = element_blank(),
   plot.background = element_blank(),
   panel.background = element_blank(),
   panel.border = element_blank(),
   panel.grid = element_blank(),
   panel.border = element_blank()
)
}
}

\section{Also See}{
 \code{\link{ggplot_waterfall}}, a
flexible but less polished alternative.
}

\examples{
{
library(ggplot2)
set.seed(1)
dfData = data.frame(x = 1:20, y = cumsum(rnorm(20)))
ggplot(dfData, aes(x =x, y = y) )+
   stat_waterfall()}
}
