% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.gg_interaction.R
\name{plot.gg_interaction}
\alias{plot.gg_interaction}
\title{plot.gg_interaction
Plot a \code{\link{gg_interaction}} object,}
\usage{
\method{plot}{gg_interaction}(x, xvar, lbls, ...)
}
\arguments{
\item{x}{gg_interaction object created from a \code{\link[randomForestSRC]{rfsrc}} object}

\item{xvar}{variable (or list of variables) of interest.}

\item{lbls}{A vector of alternative variable names.}

\item{...}{arguments passed to the \code{\link{gg_interaction}} function.}
}
\value{
\code{ggplot} object
}
\description{
plot.gg_interaction
Plot a \code{\link{gg_interaction}} object,
}
\examples{
\dontrun{
## Examples from randomForestSRC package... 
## ------------------------------------------------------------
## find interactions, classification setting
## ------------------------------------------------------------
## -------- iris data
## iris.obj <- rfsrc(Species ~., data = iris)
## TODO: VIMP interactions not handled yet....
## find.interaction(iris.obj, method = "vimp", nrep = 3)
## interaction_iris <- find.interaction(iris.obj)
data(interaction_iris, package="ggRandomForests")
gg_dta <- gg_interaction(interaction_iris)

plot(gg_dta, xvar="Petal.Width")
plot(gg_dta, xvar="Petal.Length")
plot(gg_dta, panel=TRUE)

## ------------------------------------------------------------
## find interactions, regression setting
## ------------------------------------------------------------
## -------- air quality data
## airq.obj <- rfsrc(Ozone ~ ., data = airquality)
##
## TODO: VIMP interactions not handled yet....
## find.interaction(airq.obj, method = "vimp", nrep = 3)
## interaction_airq <- find.interaction(airq.obj)
data(interaction_airq, package="ggRandomForests")
gg_dta <- gg_interaction(interaction_airq)

plot(gg_dta, xvar="Temp")
plot(gg_dta, xvar="Solar.R")
plot(gg_dta, panel=TRUE)

## -------- Boston data
data(interaction_Boston, package="ggRandomForests")
gg_dta <- gg_interaction(interaction_Boston)

plot(gg_dta, panel=TRUE)

## -------- mtcars data
data(interaction_mtcars, package="ggRandomForests")
gg_dta <- gg_interaction(interaction_mtcars)

plot(gg_dta, panel=TRUE)

## ------------------------------------------------------------
## find interactions, survival setting
## ------------------------------------------------------------
## -------- pbc data
## data(pbc, package = "randomForestSRC") 
## pbc.obj <- rfsrc(Surv(days,status) ~ ., pbc, nsplit = 10)
## interaction_pbc <- find.interaction(pbc.obj, nvar = 8)
data(interaction_pbc, package="ggRandomForests")
gg_dta <- gg_interaction(interaction_pbc)

plot(gg_dta, xvar="bili")
plot(gg_dta, xvar="copper")
plot(gg_dta, panel=TRUE)

## -------- veteran data
data(interaction_veteran, package="ggRandomForests")
gg_dta <- gg_interaction(interaction_veteran)

plot(gg_dta, panel=TRUE)

}

}
\references{
Breiman L. (2001). Random forests, Machine Learning, 45:5-32.

Ishwaran H. and Kogalur U.B. (2007). Random survival forests for 
R, Rnews, 7(2):25-31.

Ishwaran H. and Kogalur U.B. (2013). Random Forests for Survival, 
Regression and Classification (RF-SRC), R package version 1.4.
}
\seealso{
\code{\link[randomForestSRC]{rfsrc}}
\code{\link[randomForestSRC]{find.interaction}}
\code{\link[randomForestSRC]{max.subtree}} \code{\link[randomForestSRC]{var.select}} 
\code{\link[randomForestSRC]{vimp}}
\code{\link{plot.gg_interaction}}
}
