% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.gg_minimal_depth.R
\name{print.gg_minimal_depth}
\alias{print.gg_minimal_depth}
\title{Print a \code{\link{gg_minimal_depth}} object.}
\usage{
\method{print}{gg_minimal_depth}(x, ...)
}
\arguments{
\item{x}{a \code{\link{gg_minimal_depth}} object.}

\item{...}{optional arguments}
}
\description{
Print a \code{\link{gg_minimal_depth}} object.
}
\examples{
## ------------------------------------------------------------
## classification example
## ------------------------------------------------------------
\dontrun{
## You can build a randomForest
# rfsrc_iris <- rfsrc(Species ~ ., data = iris)
# varsel_iris <- var.select(rfsrc_iris)
# ... or load a cached randomForestSRC object
data(varsel_iris, package="ggRandomForests")

# Get a data.frame containing minimaldepth measures
gg_dta <- gg_minimal_depth(varsel_iris)
print(gg_dta)
}
## ------------------------------------------------------------
## regression example
## ------------------------------------------------------------
\dontrun{
# ... or load a cached randomForestSRC object
data(varsel_airq, package="ggRandomForests")

# Get a data.frame containing minimaldepth measures
gg_dta<- gg_minimal_depth(varsel_airq)
print(gg_dta)

# To nicely print a rfsrc::var.select output... 
print(varsel_airq)
}
\dontrun{
# ... or load a cached randomForestSRC object
data(varsel_Boston, package="ggRandomForests")

# Get a data.frame containing minimaldepth measures
gg_dta<- gg_minimal_depth(varsel_Boston)
print(gg_dta)

# To nicely print a rfsrc::var.select output... 
print(varsel_Boston)
}
}

