% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/quantile_cuts.R
\name{quantile_cuts}
\alias{quantile_cuts}
\title{Find the cut points of a vector, evenly distributed along the vectors values.}
\usage{
quantile_cuts(object, groups)
}
\arguments{
\item{object}{vector to be cut}

\item{groups}{how many groups do we want}
}
\value{
vector of groups+1 cut point values.
}
\description{
This function finds the cut point values from a vector argument to produce
 \code{groups} intervals. Setting \code{groups=2} will return three values,
 the two end points, and one mid point (at the median value of the vector).

The output can be passed directly into the breaks argument of the
\code{cut} function for creating groups for coplots.
}
\examples{
data(rfsrc_Boston)

# To create 6 intervals, we want 7 points.
# quantile_cuts will find balanced intervals
rm_pts <- quantile_cuts(rfsrc_Boston$xvar$rm, groups=6)

# Use cut to create the intervals
rm_grp <- cut(rfsrc_Boston$xvar$rm, breaks=rm_pts)

summary(rm_grp)
}
\seealso{
\code{cut} \code{\link{gg_partial_coplot}}
}

