% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/gg_vimp.ggRandomForests.R
\name{gg_vimp.ggRandomForests}
\alias{gg_vimp}
\alias{gg_vimp.ggRandomForests}
\title{Variable Importance (VIMP) data object}
\usage{
gg_vimp.ggRandomForests(object, ...)
}
\arguments{
\item{object}{A \code{randomForestSRC::rfsrc} object or output from \code{randomForestSRC::vimp}}

\item{...}{arguments passed to the \code{randomForestSRC::vimp.rfsrc} function if the
\code{randomForestSRC::rfsrc} object does not contain importance information.}
}
\value{
\code{gg_vimp} object. A \code{data.frame} of VIMP measures, in rank order.
}
\description{
\code{gg_vimp} Extracts the variable importance (VIMP) information from a
a \code{randomForestSRC::rfsrc} object.
}
\examples{
## ------------------------------------------------------------
## classification example
## ------------------------------------------------------------
# rfsrc_iris <- rfsrc(Species ~ ., data = iris)
data(rfsrc_iris, package="ggRandomForests")
gg_dta <- gg_vimp(rfsrc_iris)
plot(gg_dta)

## ------------------------------------------------------------
## regression example
## ------------------------------------------------------------

# rfsrc_airq <- rfsrc(Ozone ~ ., airquality)
data(rfsrc_airq, package="ggRandomForests")
gg_dta <- gg_vimp(rfsrc_airq)
plot(gg_dta)

## ------------------------------------------------------------
## survival example
## ------------------------------------------------------------
data(rfsrc_veteran, package="ggRandomForests")
gg_dta <- gg_vimp(rfsrc_veteran)
plot(gg_dta)
}
\references{
Ishwaran H. (2007). Variable importance in binary regression trees and forests,
\emph{Electronic J. Statist.}, 1:519-537.
}
\seealso{
\code{\link{plot.gg_vimp}} \code{randomForestSRC::rfsrc} \code{randomForestSRC::vimp}
}

