% Generated by roxygen2 (4.0.2): do not edit by hand
\name{gg_vimp.ggRandomForests}
\alias{gg_vimp}
\alias{gg_vimp.ggRandomForests}
\title{Variable Importance (VIMP) data object}
\usage{
gg_vimp.ggRandomForests(object, ...)
}
\arguments{
\item{object}{A \code{randomForestSRC::rfsrc} object or output from \code{randomForestSRC::vimp}}

\item{...}{arguments passed to the \code{randomForestSRC::vimp.rfsrc} function if the
\code{randomForestSRC::rfsrc} object does not contain importance information.}
}
\value{
a matrix of VIMP measures, in rank order.
}
\description{
\code{gg_vimp} Extracts the variable importance (VIMP) information from a
a \code{randomForestSRC::rfsrc} object.
}
\examples{
## ------------------------------------------------------------
## classification example
## ------------------------------------------------------------
# iris_rf <- rfsrc(Species ~ ., data = iris)
data(iris_rf, package="ggRandomForests")
ggrf <- gg_vimp(iris_rf)
plot(ggrf)

## ------------------------------------------------------------
## regression example
## ------------------------------------------------------------

# airq.obj <- rfsrc(Ozone ~ ., airquality)
data(airq_rf, package="ggRandomForests")
ggrf <- gg_vimp(airq_rf)
plot(ggrf)

## ------------------------------------------------------------
## survival example
## ------------------------------------------------------------
data(veteran_rf, package="ggRandomForests")
ggrf <- gg_vimp(veteran_rf)
plot(ggrf)
}
\references{
Ishwaran H. (2007). Variable importance in binary regression trees and forests,
\emph{Electronic J. Statist.}, 1:519-537.
}
\seealso{
\code{\link{plot.gg_vimp}} \code{randomForestSRC::rfsrc} \code{randomForestSRC::vimp}
}

