% Generated by roxygen2 (4.0.2): do not edit by hand
\name{plot.gg_partial}
\alias{plot.gg_partial}
\title{Partial variable dependence plot, operates on a \code{\link{gg_partial}} object.}
\usage{
\method{plot}{gg_partial}(x, points = TRUE, smooth = "loess", ...)
}
\arguments{
\item{x}{\code{\link{gg_partial}} object created from a \code{randomForestSRC::rfsrc} forest object}

\item{points}{plot points (boolean)}

\item{smooth}{use smooth curve (by type)}

\item{...}{extra arguments}
}
\value{
\code{ggplot} object
}
\description{
Generate a risk adjusted (partial) variable dependence plot.
The function plots the \code{randomForestSRC::rfsrc} response variable (y-axis) against
the covariate of interest (specified when creating the
 \code{\link{gg_partial}} object).
}
\examples{
\dontrun{
## ------------------------------------------------------------
## classification
## ------------------------------------------------------------

## iris "Petal.Width" partial dependence plot
##
# iris_rf <- rfsrc(Species ~., data = iris)
# iris_prtl <- plot.variable(iris_rf, xvar.names = "Petal.Width",
#                            partial=TRUE)
data(iris_prtl, package="ggRandomForests")

ggrf_obj <- gg_partial(iris_prtl)
plot(ggrf_obj)

## ------------------------------------------------------------
## regression
## ------------------------------------------------------------

## airquality "Wind" partial dependence plot
##
# airq_rf <- rfsrc(Ozone ~ ., data = airquality)
# airq_prtl <- plot.variable(airq_rf, xvar.names = "Wind",
#                            partial=TRUE, show.plot=FALSE)
data(airq_prtl, package="ggRandomForests")

ggrf_obj <- gg_partial(airq_prtl)
plot(ggrf_obj)

## ------------------------------------------------------------
## survival examples
## ------------------------------------------------------------
## survival "age" partial variable dependence plot
##
# data(veteran, package = "randomForestSRC")
# veteran_rf <- rfsrc(Surv(time,status)~., veteran, nsplit = 10, ntree = 100)
#
## 30 day partial plot for age
# veteran_prtl <- plot.variable(veteran_rf, surv.type = "surv",
#                               partial = TRUE, time=30,
#                               xvar.names = "age",
#                               show.plots=FALSE)
data(veteran_prtl, package="ggRandomForests")

ggrf_obj <- gg_partial(veteran_prtl)
plot(ggrf_obj)
}
}
\references{
Breiman L. (2001). Random forests, Machine Learning, 45:5-32.

Ishwaran H. and Kogalur U.B. (2007). Random survival forests for R,
Rnews, 7(2):25-31.

Ishwaran H. and Kogalur U.B. (2013). Random Forests for Survival,
Regression and Classification (RF-SRC), R package version 1.4.
}
\seealso{
\code{randomForestSRC::plot.variable} \code{\link{gg_partial}}
\code{\link{plot.gg_partial_list}} \code{\link{gg_variable}}
\code{\link{plot.gg_variable}}
}

