% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moran.R
\name{expected_mc}
\alias{expected_mc}
\title{Expected value of the residual Moran coefficient}
\source{
Chun, Yongwan and Griffith, Daniel A. (2013). Spatial statistics and geostatistics. Sage, p. 18.
}
\usage{
expected_mc(X, C)
}
\arguments{
\item{X}{model matrix, including column of ones.}

\item{C}{Connectivity matrix.}
}
\value{
Returns a numeric value.
}
\description{
Expected value for the Moran coefficient of model residuals under the null hypothesis of no spatial autocorrelation.
}
\examples{
data(georgia)
C <- shape2mat(georgia)
X <- model.matrix(~ college, georgia)
expected_mc(X, C)
}
